/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DateTimeUtils {
    private static final String DEFAULT_DATE_TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";

    public static long betweenNowSeconds(Long timestamp) {
        return DateTimeUtils.betweenNowSeconds(LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()));
    }

    public static long betweenNowSeconds(LocalDateTime time) {
        return ChronoUnit.SECONDS.between(time, LocalDateTime.now());
    }

    public static long betweenNowSeconds(Date date) {
        return ChronoUnit.SECONDS.between(DateTimeUtils.dateToDateTime(date), LocalDateTime.now());
    }

    public static long afterNowSeconds(Date date) {
        return ChronoUnit.SECONDS.between(LocalDateTime.now(), DateTimeUtils.dateToDateTime(date));
    }

    public static Date getNow() {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String getNowString() {
        return DateTimeUtils.format(DateTimeUtils.getNow());
    }

    public static String format(Date date) {
        return DateTimeUtils.format(date, DEFAULT_DATE_TIME_FORMATTER);
    }

    public static String format(Date date, String pattern) {
        return Objects.isNull(date) ? null : DateTimeFormatter.ofPattern(StringUtils.defaultString((String)pattern, (String)DEFAULT_DATE_TIME_FORMATTER)).format(DateTimeUtils.dateToDateTime(date));
    }

    public static LocalDateTime dateToDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }
}

