/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils.http;

import com.xkzhangsan.time.cost.Cost;
import com.xkzhangsan.time.cost.CostUtil;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import online.inote.naruto.utils.log.LoggerFactory;

public class LogInterceptor
implements Interceptor {
    private static final String POST_METHOD = "POST";
    private final LoggerFactory log = LoggerFactory.getLogger(this.getClass()).module("OK-HTTP-3");

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.log.info().message("request:[ {} ]").args(request.toString()).print();
        if (POST_METHOD.equals(request.method())) {
            this.log.info().message("request-headers:[ {} ]").args(request.headers().toString()).print();
            RequestBody requestBody = request.body();
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            this.log.info().message("request-contentType:[ {} ]").args(requestBody.contentType().toString()).print();
            this.log.info().message("request-body:[ {} ]").args(buffer.readByteString().utf8()).print();
        }
        Cost cost = CostUtil.startMillisecondCost();
        Response response = chain.proceed(request);
        this.log.info().message(cost.stopAccurateAndFormat()).print();
        this.log.info().message("response-code:[ {} ]").args(response.code()).print();
        return response;
    }
}

