/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils.http;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum MediaTypeEnum {
    TEXT("text"),
    JSON("json"),
    HTML("html"),
    WEB_VIEW_HTML("webviewhtml");

    private static Map<String, MediaTypeEnum> MEDIA_TYPE_MAP;
    private String type;

    public static boolean contains(String mediaType) {
        return MEDIA_TYPE_MAP.containsKey(mediaType);
    }

    public String getType() {
        return this.type;
    }

    private MediaTypeEnum(String type) {
        this.type = type;
    }

    static {
        MEDIA_TYPE_MAP = Arrays.stream(MediaTypeEnum.values()).collect(Collectors.toMap(MediaTypeEnum::getType, m -> m));
    }
}

