/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import okhttp3.Response;
import online.inote.naruto.exception.HttpException;
import online.inote.naruto.utils.http.DefaultResultConvertor;
import online.inote.naruto.utils.http.ResultConvertor;

public class Result {
    private Response response;
    private ResultConvertor convertor;
    private InputStream in;

    public boolean isSuccess() {
        return this.response.isSuccessful();
    }

    public <T> T toBean(Type type) {
        if (this.response.isSuccessful()) {
            assert (this.response.body() != null);
            return this.getConvertor().toBean(type, this.response.body().byteStream(), StandardCharsets.UTF_8);
        }
        throw new RuntimeException("\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25");
    }

    public <T> T toBean(TypeReference<T> type, Feature ... features) {
        if (this.response.isSuccessful()) {
            assert (this.response.body() != null);
            try {
                return (T)JSON.parseObject((String)this.getConvertor().mapping(this.response.body().string()), type, (Feature[])features);
            }
            catch (IOException e) {
                throw new HttpException("Http\u8bbf\u95ee\u5f02\u5e38", (Throwable)e);
            }
        }
        throw new RuntimeException("\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25");
    }

    public <T> List<T> toList(Class<T> clazz) {
        if (this.response.isSuccessful()) {
            assert (this.response.body() != null);
            return this.getConvertor().toList(clazz, this.response.body().byteStream(), StandardCharsets.UTF_8);
        }
        throw new RuntimeException("\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25");
    }

    public String getBody() throws IOException {
        return this.response.body().string();
    }

    private ResultConvertor getConvertor() {
        if (Objects.nonNull(this.convertor)) {
            return this.convertor;
        }
        return new DefaultResultConvertor();
    }

    Result(Response response, ResultConvertor convertor, InputStream in) {
        this.response = response;
        this.convertor = convertor;
        this.in = in;
    }

    public static ResultBuilder builder() {
        return new ResultBuilder();
    }

    public static class ResultBuilder {
        private Response response;
        private ResultConvertor convertor;
        private InputStream in;

        ResultBuilder() {
        }

        public ResultBuilder response(Response response) {
            this.response = response;
            return this;
        }

        public ResultBuilder convertor(ResultConvertor convertor) {
            this.convertor = convertor;
            return this;
        }

        public ResultBuilder in(InputStream in) {
            this.in = in;
            return this;
        }

        public Result build() {
            return new Result(this.response, this.convertor, this.in);
        }

        public String toString() {
            return "Result.ResultBuilder(response=" + this.response + ", convertor=" + this.convertor + ", in=" + this.in + ")";
        }
    }
}

