/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils.log;

import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.log.DebugLogger;
import online.inote.naruto.utils.log.ErrorLogger;
import online.inote.naruto.utils.log.InfoLogger;
import online.inote.naruto.utils.log.TraceLogger;
import online.inote.naruto.utils.log.WarnLogger;
import org.slf4j.Logger;

public final class LoggerFactory {
    private Logger logger;
    private String module;

    private LoggerFactory() {
    }

    private LoggerFactory(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory module(String module) {
        this.module = module;
        return this;
    }

    public TraceLogger trace() {
        return new TraceLogger(this.logger, this.module);
    }

    public DebugLogger debug() {
        return new DebugLogger(this.logger, this.module);
    }

    public InfoLogger info() {
        return new InfoLogger(this.logger, this.module);
    }

    public WarnLogger warn() {
        return new WarnLogger(this.logger, this.module);
    }

    public ErrorLogger error() {
        return new ErrorLogger(this.logger, this.module);
    }

    public static LoggerFactory getLogger(Class<?> clazz) {
        return LoggerFactory.builder().logger(clazz).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Logger logger;

        public Builder logger(Class<?> clazz) {
            this.logger = org.slf4j.LoggerFactory.getLogger(clazz);
            return this;
        }

        public LoggerFactory build() {
            Assert.nonNull(this.logger, "logger cannot be null.");
            return new LoggerFactory(this.logger);
        }
    }
}

