/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.exec.common;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import online.sharedtype.exec.common.DependencyResolver;
import online.sharedtype.exec.common.Logger;
import online.sharedtype.exec.common.SimpleDiagnosticListener;
import online.sharedtype.exec.common.SimpleLoggerWriter;
import online.sharedtype.exec.common.SourceFileVisitor;

public final class AnnotationProcessorExecutor {
    private static final String JAVA8_VERSION = "1.8";
    private final Processor processor;
    private final Logger log;
    private final DependencyResolver dependencyResolver;

    public AnnotationProcessorExecutor(Processor processor, Logger log, DependencyResolver dependencyResolver) {
        this.processor = processor;
        this.log = log;
        this.dependencyResolver = dependencyResolver;
    }

    public boolean execute(Path projectBaseDir, Path outputDir, Iterable<Path> compileSourceRoots, String sourceEncoding, Iterable<String> compilerOptions) throws Exception {
        SimpleDiagnosticListener diagnosticListener = new SimpleDiagnosticListener(this.log, projectBaseDir);
        JavaCompiler compiler = AnnotationProcessorExecutor.getJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, AnnotationProcessorExecutor.getCharset(sourceEncoding));
        try (SimpleLoggerWriter logger = new SimpleLoggerWriter(this.log);){
            if (Files.notExists(outputDir, new LinkOption[0])) {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            fileManager.setLocation(StandardLocation.SOURCE_OUTPUT, Collections.singleton(outputDir.toFile()));
            fileManager.setLocation(StandardLocation.CLASS_PATH, this.dependencyResolver.getClasspathDependencies());
            Iterable<? extends JavaFileObject> sources = fileManager.getJavaFileObjectsFromFiles(AnnotationProcessorExecutor.walkAllSourceFiles(compileSourceRoots));
            JavaCompiler.CompilationTask task = compiler.getTask(logger, fileManager, diagnosticListener, compilerOptions, null, sources);
            task.setProcessors(Collections.singleton(this.processor));
            boolean bl = task.call();
            return bl;
        }
    }

    private static List<File> walkAllSourceFiles(Iterable<Path> compileSourceRoots) throws IOException {
        SourceFileVisitor visitor = new SourceFileVisitor();
        for (Path compileSourceRoot : compileSourceRoots) {
            if (!Files.isDirectory(compileSourceRoot, new LinkOption[0])) continue;
            Files.walkFileTree(compileSourceRoot, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
        }
        return visitor.getFiles();
    }

    private static JavaCompiler getJavaCompiler() throws Exception {
        JavaCompiler compiler;
        String javaVersion = System.getProperty("java.specification.version");
        if (JAVA8_VERSION.equals(javaVersion)) {
            Class<?> javacToolClass = Class.forName("com.sun.tools.javac.api.JavacTool");
            compiler = (JavaCompiler)javacToolClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            compiler = ToolProvider.getSystemJavaCompiler();
        }
        if (compiler != null) {
            return compiler;
        }
        throw new ClassNotFoundException("Java compiler not found, currently only compiler from jdk.compiler module is supported.");
    }

    private static Charset getCharset(String encoding) {
        if (encoding != null) {
            return Charset.forName(encoding);
        }
        return null;
    }
}

