/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.exec.common;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SharedTypeApCompilerOptions {
    private static final List<String> DEFAULT_COMPILER_OPTIONS = Arrays.asList("-proc:only", "-Asharedtype.enabled=true");
    private static final String OPTION_PROPS_FILE_KEY = "-Asharedtype.propsFile=";
    private final String propertyFile;

    public SharedTypeApCompilerOptions(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public SharedTypeApCompilerOptions(File propertyFile) {
        this(propertyFile == null ? null : propertyFile.getAbsolutePath());
    }

    public List<String> toList() {
        ArrayList<String> options = new ArrayList<String>(DEFAULT_COMPILER_OPTIONS.size() + 1);
        options.addAll(DEFAULT_COMPILER_OPTIONS);
        if (this.propertyFile != null) {
            if (Files.notExists(Paths.get(this.propertyFile, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException("Property file not found: " + this.propertyFile);
            }
            options.add(OPTION_PROPS_FILE_KEY + this.propertyFile);
        }
        return options;
    }
}

