/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.exec.common;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import online.sharedtype.exec.common.Logger;

final class SimpleDiagnosticListener
implements DiagnosticListener<JavaFileObject> {
    private final Logger log;
    private final Path projectBaseDir;

    SimpleDiagnosticListener(Logger log, Path projectBaseDir) {
        this.log = log;
        this.projectBaseDir = projectBaseDir;
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        StringBuilder sb = new StringBuilder();
        this.addSourceInfo(sb, diagnostic);
        sb.append(diagnostic.getMessage(null));
        String message = sb.toString();
        switch (diagnostic.getKind()) {
            case NOTE: 
            case OTHER: {
                this.log.info(message);
                break;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                this.log.warn(message);
                break;
            }
            case ERROR: {
                this.log.error(message);
            }
        }
    }

    void addSourceInfo(StringBuilder sb, Diagnostic<? extends JavaFileObject> diagnostic) {
        if (diagnostic.getSource() == null) {
            return;
        }
        JavaFileObject source = diagnostic.getSource();
        sb.append(this.projectBaseDir.relativize(Paths.get(source.getName(), new String[0])));
        sb.append(':');
        sb.append(diagnostic.getLineNumber());
        sb.append(':');
        sb.append(diagnostic.getColumnNumber());
        sb.append(" ");
    }
}

