/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.exec.common;

import java.io.Writer;
import online.sharedtype.exec.common.Logger;

final class SimpleLoggerWriter
extends Writer {
    private final Logger log;
    private final StringBuffer buffer = new StringBuffer();

    SimpleLoggerWriter(Logger log) {
        this.log = log;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.buffer.append(cbuf, off, len);
    }

    @Override
    public void flush() {
        SimpleLoggerWriter.removeNewLine(this.buffer);
        String message = this.buffer.toString();
        if (!message.isEmpty()) {
            this.log.info(message);
        }
        this.buffer.setLength(0);
    }

    @Override
    public void close() {
        this.flush();
    }

    private static void removeNewLine(StringBuffer buffer) {
        char c;
        if (buffer.length() <= 0) {
            return;
        }
        while ((c = buffer.charAt(buffer.length() - 1)) == '\n' || c == '\r') {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
    }
}

