/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.PropsFactory;
import online.sharedtype.processor.domain.Constants;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.parser.TypeDefParser;
import online.sharedtype.processor.resolver.TypeResolver;
import online.sharedtype.processor.support.Preconditions;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.support.exception.SharedTypeException;
import online.sharedtype.processor.support.exception.SharedTypeInternalError;
import online.sharedtype.processor.writer.TypeWriter;

@SupportedAnnotationTypes(value={"online.sharedtype.SharedType"})
@SupportedOptions(value={"sharedtype.propsFile", "sharedtype.enabled"})
@AutoService(value={Processor.class})
public final class SharedTypeAnnotationProcessor
extends AbstractProcessor {
    private static final String PROPS_FILE_OPTION_NAME = "sharedtype.propsFile";
    private static final String PROPS_ENABLED = "sharedtype.enabled";
    private static final String DEFAULT_USER_PROPS_FILE = "sharedtype.properties";
    private static final boolean ANNOTATION_CONSUMED = true;
    @Nullable
    private Map<String, String> userProps;
    private boolean enabled;
    Context ctx;
    TypeDefParser parser;
    TypeResolver resolver;
    TypeWriter writer;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String userPropsFile = processingEnv.getOptions().getOrDefault(PROPS_FILE_OPTION_NAME, DEFAULT_USER_PROPS_FILE);
        this.enabled = SharedTypeAnnotationProcessor.isEnabled(processingEnv);
        if (this.enabled) {
            this.ctx = new Context(processingEnv, PropsFactory.loadProps(Paths.get(userPropsFile, new String[0]), this.userProps));
            this.parser = TypeDefParser.create(this.ctx);
            this.resolver = TypeResolver.create(this.ctx, this.parser);
            this.writer = TypeWriter.create(this.ctx);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.enabled || annotations.isEmpty()) {
            return true;
        }
        if (annotations.size() > 1) {
            throw new SharedTypeInternalError(String.format("Only annotation %s is expected.", Constants.ANNOTATION_QUALIFIED_NAME));
        }
        TypeElement annotation = annotations.iterator().next();
        Preconditions.checkArgument(annotation.getQualifiedName().contentEquals(Constants.ANNOTATION_QUALIFIED_NAME), "Wrong anno: %s", annotation);
        this.doProcess(roundEnv.getElementsAnnotatedWith(annotation));
        return true;
    }

    void doProcess(Set<? extends Element> elements) {
        ArrayList<TypeDef> discoveredDefs = new ArrayList<TypeDef>(elements.size());
        for (Element element : elements) {
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                List<TypeDef> typeDefs = this.parser.parse(typeElement);
                discoveredDefs.addAll(typeDefs);
                if (!typeDefs.isEmpty()) continue;
                this.ctx.warn(element, "Type '%s' is ignored or invalid, but annotated with '%s'.", typeElement.getQualifiedName().toString(), Constants.ANNOTATION_QUALIFIED_NAME);
                continue;
            }
            throw new SharedTypeInternalError(String.format("Unsupported element: %s of kind %s", new Object[]{element, element.getKind()}));
        }
        List<TypeDef> resolvedDefs = this.resolver.resolve(discoveredDefs);
        try {
            this.writer.write(resolvedDefs);
        }
        catch (IOException iOException) {
            throw new SharedTypeException("Failed to write,", iOException);
        }
    }

    private static boolean isEnabled(ProcessingEnvironment processingEnv) {
        String enabledExpr = processingEnv.getOptions().getOrDefault(PROPS_ENABLED, "false");
        return enabledExpr.equalsIgnoreCase("true") || enabledExpr.equalsIgnoreCase("yes");
    }

    @Generated
    public void setUserProps(Map<String, String> userProps) {
        this.userProps = userProps;
    }
}

