/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.context;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.EnumParsingUtils;
import online.sharedtype.processor.context.Props;
import online.sharedtype.processor.support.exception.SharedTypeException;
import online.sharedtype.processor.support.utils.Utils;

public final class Config {
    private final SharedType anno;
    private final boolean annotated;
    private final String simpleName;
    private final String qualifiedName;
    private final Set<SharedType.ComponentType> includedComponentTypes;
    private final boolean constantNamespaced;
    private final Set<Props.Typescript.OptionalFieldFormat> typescriptOptionalFieldFormats;
    private final Props.Typescript.EnumFormat typescriptEnumFormat;
    private final Props.Typescript.FieldReadonlyType typescriptFieldReadonly;
    private final Props.Go.EnumFormat goEnumFormat;
    private final String typescriptTargetDatetimeTypeLiteral;
    private final String goTargetDatetimeTypeLiteral;
    private final String rustTargetDatetimeTypeLiteral;
    private final String rustConstKeyword;

    public Config(TypeElement typeElement, Context ctx) {
        String simpleName = typeElement.getSimpleName().toString();
        SharedType annoFromType = typeElement.getAnnotation(SharedType.class);
        this.annotated = annoFromType != null;
        this.anno = annoFromType == null ? DummyDefault.class.getAnnotation(AnnoContainer.class).anno() : annoFromType;
        this.simpleName = this.anno.name().isEmpty() ? simpleName : this.anno.name();
        this.qualifiedName = typeElement.getQualifiedName().toString();
        List<SharedType.ComponentType> includedCompTypes = Arrays.asList(this.anno.includes());
        this.includedComponentTypes = includedCompTypes.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(includedCompTypes);
        this.constantNamespaced = Config.evaluateOptionalBool(this.anno.constantNamespaced(), ctx.getProps().isConstantNamespaced());
        this.typescriptOptionalFieldFormats = this.parseTsOptionalFieldFormats(this.anno, ctx);
        this.typescriptEnumFormat = this.parseTsEnumFormat(this.anno, ctx);
        this.typescriptFieldReadonly = this.parseTsFieldReadonlyType(this.anno, ctx);
        this.goEnumFormat = this.parseGoEnumFormat(this.anno, ctx);
        this.typescriptTargetDatetimeTypeLiteral = Utils.notEmptyOrDefault(this.anno.typescriptTargetDatetimeTypeLiteral(), ctx.getProps().getTypescript().getTargetDatetimeTypeLiteral(), () -> String.format("Loading typescriptTargetDatetimeTypeLiteral failed. Please check your configuration for '%s'", this.qualifiedName));
        this.goTargetDatetimeTypeLiteral = Utils.notEmptyOrDefault(this.anno.goTargetDatetimeTypeLiteral(), ctx.getProps().getGo().getTargetDatetimeTypeLiteral(), () -> String.format("Loading goTargetDatetimeTypeLiteral failed. Please check your configuration for '%s'", this.qualifiedName));
        this.rustTargetDatetimeTypeLiteral = Utils.notEmptyOrDefault(this.anno.rustTargetDatetimeTypeLiteral(), ctx.getProps().getRust().getTargetDatetimeTypeLiteral(), () -> String.format("Loading rustTargetDatetimeTypeLiteral failed. Please check your configuration for '%s'", this.qualifiedName));
        this.rustConstKeyword = Config.validateRustConstKeyword(this.anno.rustConstKeyword());
    }

    public boolean includes(SharedType.ComponentType componentType) {
        return this.includedComponentTypes.contains(componentType);
    }

    private static boolean evaluateOptionalBool(SharedType.OptionalBool optionalBool, boolean defaultValue) {
        if (optionalBool == SharedType.OptionalBool.TRUE) {
            return true;
        }
        if (optionalBool == SharedType.OptionalBool.FALSE) {
            return false;
        }
        return defaultValue;
    }

    private Set<Props.Typescript.OptionalFieldFormat> parseTsOptionalFieldFormats(SharedType anno, Context ctx) {
        if (anno.typescriptOptionalFieldFormat().length > 0) {
            List<String> values = Arrays.asList(anno.typescriptOptionalFieldFormat());
            try {
                return EnumParsingUtils.parseEnumSet(values, Props.Typescript.OptionalFieldFormat.class, Props.Typescript.OptionalFieldFormat::fromString);
            }
            catch (IllegalArgumentException e) {
                throw new SharedTypeException(String.format("Invalid value for SharedType.typescriptOptionalFieldFormat: %s, only '?', 'null', 'undefined' are allowed. When parsing annotation for '%s'.", values, this.qualifiedName), e);
            }
        }
        return ctx.getProps().getTypescript().getOptionalFieldFormats();
    }

    private Props.Typescript.EnumFormat parseTsEnumFormat(SharedType anno, Context ctx) {
        if (anno.typescriptEnumFormat() != null && !anno.typescriptEnumFormat().isEmpty()) {
            try {
                return Props.Typescript.EnumFormat.fromString(anno.typescriptEnumFormat());
            }
            catch (IllegalArgumentException e) {
                throw new SharedTypeException(String.format("Invalid value for SharedType.typescriptEnumFormat: '%s', only one of 'union', 'const_enum', 'enum' is allowed. When parsing annotation for '%s'.", anno.typescriptEnumFormat(), this.qualifiedName), e);
            }
        }
        return ctx.getProps().getTypescript().getEnumFormat();
    }

    private Props.Typescript.FieldReadonlyType parseTsFieldReadonlyType(SharedType anno, Context ctx) {
        if (anno.typescriptFieldReadonlyType() != null && !anno.typescriptFieldReadonlyType().isEmpty()) {
            try {
                return Props.Typescript.FieldReadonlyType.fromString(anno.typescriptFieldReadonlyType());
            }
            catch (IllegalArgumentException e) {
                throw new SharedTypeException(String.format("Invalid value for SharedType.typescriptFieldReadonlyType: '%s', only 'all', 'acyclic', 'none' is allowed. When parsing annotation for '%s'.", anno.typescriptFieldReadonlyType(), this.qualifiedName), e);
            }
        }
        return ctx.getProps().getTypescript().getFieldReadonlyType();
    }

    private Props.Go.EnumFormat parseGoEnumFormat(SharedType anno, Context ctx) {
        if (anno.goEnumFormat() != null && !anno.goEnumFormat().isEmpty()) {
            try {
                return Props.Go.EnumFormat.fromString(anno.goEnumFormat());
            }
            catch (IllegalArgumentException e) {
                throw new SharedTypeException(String.format("Invalid value for SharedType.goEnumFormat: '%s', only 'const' or 'struct' is allowed. When parsing annotation for '%s'.", anno.goEnumFormat(), this.qualifiedName), e);
            }
        }
        return ctx.getProps().getGo().getEnumFormat();
    }

    private static String validateRustConstKeyword(String rustConstKeyword) {
        if (!rustConstKeyword.equals("const") && !rustConstKeyword.equals("static")) {
            throw new SharedTypeException(String.format("Invalid value for SharedType.rustConstKeyword: '%s', only 'const' or 'static' is allowed.", rustConstKeyword));
        }
        return rustConstKeyword;
    }

    @Generated
    public SharedType getAnno() {
        return this.anno;
    }

    @Generated
    public boolean isAnnotated() {
        return this.annotated;
    }

    @Generated
    public String getSimpleName() {
        return this.simpleName;
    }

    @Generated
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Generated
    public Set<SharedType.ComponentType> getIncludedComponentTypes() {
        return this.includedComponentTypes;
    }

    @Generated
    public boolean isConstantNamespaced() {
        return this.constantNamespaced;
    }

    @Generated
    public Set<Props.Typescript.OptionalFieldFormat> getTypescriptOptionalFieldFormats() {
        return this.typescriptOptionalFieldFormats;
    }

    @Generated
    public Props.Typescript.EnumFormat getTypescriptEnumFormat() {
        return this.typescriptEnumFormat;
    }

    @Generated
    public Props.Typescript.FieldReadonlyType getTypescriptFieldReadonly() {
        return this.typescriptFieldReadonly;
    }

    @Generated
    public Props.Go.EnumFormat getGoEnumFormat() {
        return this.goEnumFormat;
    }

    @Generated
    public String getTypescriptTargetDatetimeTypeLiteral() {
        return this.typescriptTargetDatetimeTypeLiteral;
    }

    @Generated
    public String getGoTargetDatetimeTypeLiteral() {
        return this.goTargetDatetimeTypeLiteral;
    }

    @Generated
    public String getRustTargetDatetimeTypeLiteral() {
        return this.rustTargetDatetimeTypeLiteral;
    }

    @Generated
    public String getRustConstKeyword() {
        return this.rustConstKeyword;
    }

    @AnnoContainer
    static final class DummyDefault {
        DummyDefault() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface AnnoContainer {
        public SharedType anno() default @SharedType;
    }
}

