/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.context;

import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Props;
import online.sharedtype.processor.context.RenderFlags;
import online.sharedtype.processor.context.TypeStore;
import online.sharedtype.processor.domain.component.TagLiteralContainer;

public final class Context {
    private final TypeStore typeStore = new TypeStore();
    private final RenderFlags renderFlags = new RenderFlags();
    private final ProcessingEnvironment processingEnv;
    private final Props props;
    private final Types types;
    private final Trees trees;

    public Context(ProcessingEnvironment processingEnv, Props props) {
        this.processingEnv = processingEnv;
        this.props = props;
        this.types = processingEnv.getTypeUtils();
        Trees trees = null;
        try {
            trees = Trees.instance(processingEnv);
        }
        catch (IllegalArgumentException e) {
            this.warn("The provided processingEnv '%s' (%s) does not support Tree API, some features may not work. Error message: %s", processingEnv, processingEnv.getClass(), e.getMessage());
        }
        this.trees = trees;
    }

    public void info(Element element, String message, Object ... objects) {
        this.log(Diagnostic.Kind.NOTE, element, message, objects);
    }

    public void warn(Element element, String message, Object ... objects) {
        this.log(Diagnostic.Kind.WARNING, element, message, objects);
    }

    public void error(Element element, String message, Object ... objects) {
        this.log(Diagnostic.Kind.ERROR, element, message, objects);
    }

    public void info(String message, Object ... objects) {
        this.log(Diagnostic.Kind.NOTE, null, message, objects);
    }

    public void warn(String message, Object ... objects) {
        this.log(Diagnostic.Kind.WARNING, null, message, objects);
    }

    public boolean isArraylike(TypeMirror typeMirror) {
        return this.isSubtypeOfAny(typeMirror, this.props.getArraylikeTypeQualifiedNames());
    }

    public boolean isTopArrayType(TypeMirror typeMirror) {
        return Context.isSameTypeOfAny(typeMirror, this.props.getArraylikeTypeQualifiedNames());
    }

    public boolean isMaplike(TypeMirror typeMirror) {
        return this.isSubtypeOfAny(typeMirror, this.props.getMaplikeTypeQualifiedNames());
    }

    public boolean isDatetimelike(TypeMirror typeMirror) {
        return this.isSubtypeOfAny(typeMirror, this.props.getDatetimelikeTypeQualifiedNames());
    }

    public boolean isEnumType(TypeMirror typeMirror) {
        return this.types.asElement(typeMirror).getKind() == ElementKind.ENUM;
    }

    public boolean isIgnored(Element element) {
        if (element.getAnnotation(SharedType.Ignore.class) != null) {
            return true;
        }
        boolean hasIgnoreAnnotation = Context.isAnnotatedByQualifiedNames(element, this.props.getIgnoreAnnotations());
        if (hasIgnoreAnnotation) {
            return true;
        }
        if (element.getKind() == ElementKind.FIELD) {
            return this.props.getIgnoredFieldNames().contains(element.getSimpleName().toString());
        }
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return this.props.getIgnoredTypeQualifiedNames().contains(typeElement.getQualifiedName().toString());
        }
        return false;
    }

    public boolean isOptionalAnnotated(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annoTypeQualifiedName = annotationMirror.getAnnotationType().toString();
            if (!this.props.getOptionalAnnotations().contains(annoTypeQualifiedName)) continue;
            return true;
        }
        return false;
    }

    public boolean isOptionalType(String qualifiedName) {
        return this.props.getOptionalContainerTypes().contains(qualifiedName);
    }

    public boolean isExplicitAccessor(ExecutableElement element) {
        if (element.getAnnotation(SharedType.Accessor.class) != null) {
            return true;
        }
        return Context.isAnnotatedByQualifiedNames(element, this.props.getAccessorAnnotations());
    }

    public boolean isAnnotatedAsEnumValue(Element element) {
        if (element.getAnnotation(SharedType.EnumValue.class) != null) {
            return true;
        }
        return Context.isAnnotatedByQualifiedNames(element, this.props.getEnumValueAnnotations());
    }

    public Map<SharedType.TargetType, List<TagLiteralContainer>> extractTagLiterals(Element element) {
        SharedType.TagLiteral[] tagLiterals = (SharedType.TagLiteral[])element.getAnnotationsByType(SharedType.TagLiteral.class);
        if (tagLiterals.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<SharedType.TargetType, List<TagLiteralContainer>> tagLiteralsByTargetCodeType = new HashMap<SharedType.TargetType, List<TagLiteralContainer>>();
        for (SharedType.TagLiteral tagLiteral : tagLiterals) {
            Collection<SharedType.TargetType> targets = tagLiteral.targets().length > 0 ? Arrays.asList(tagLiteral.targets()) : this.props.getTargetTypes();
            for (SharedType.TargetType target : targets) {
                tagLiteralsByTargetCodeType.compute(target, (k, v) -> v == null ? new ArrayList() : v).add(new TagLiteralContainer(Arrays.asList(tagLiteral.tags()), tagLiteral.position()));
            }
        }
        return tagLiteralsByTargetCodeType;
    }

    public String getTypeQualifiedName(DeclaredType typeMirror) {
        TypeElement element = (TypeElement)this.types.asElement(typeMirror);
        return element.getQualifiedName().toString();
    }

    public FileObject createSourceOutput(String filename) throws IOException {
        return this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", filename, new Element[0]);
    }

    private void log(Diagnostic.Kind level, Element element, String message, Object ... objects) {
        this.processingEnv.getMessager().printMessage(level, String.format("[ST] %s", String.format(message, objects)), element);
    }

    boolean isSubtypeOfAny(TypeMirror typeMirror, Set<String> qualifiedNames) {
        ArrayDeque<TypeMirror> queue = new ArrayDeque<TypeMirror>();
        queue.add(typeMirror);
        HashSet<TypeMirror> visited = new HashSet<TypeMirror>();
        while (!queue.isEmpty()) {
            TypeMirror type = (TypeMirror)queue.poll();
            if (Context.isSameTypeOfAny(type, qualifiedNames)) {
                return true;
            }
            for (TypeMirror typeMirror2 : this.types.directSupertypes(type)) {
                if (visited.contains(typeMirror2) || this.props.getIgnoredTypeQualifiedNames().contains(typeMirror2.toString())) continue;
                queue.add(typeMirror2);
                visited.add(typeMirror2);
            }
        }
        return false;
    }

    private static boolean isSameTypeOfAny(TypeMirror typeMirror, Set<String> qualifiedNames) {
        Element element;
        if (typeMirror instanceof DeclaredType && (element = ((DeclaredType)typeMirror).asElement()) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return qualifiedNames.contains(typeElement.getQualifiedName().toString());
        }
        return false;
    }

    private static boolean isAnnotatedByQualifiedNames(Element element, Set<String> qualifiedNames) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annoTypeQualifiedName = annotationMirror.getAnnotationType().toString();
            if (!qualifiedNames.contains(annoTypeQualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public TypeStore getTypeStore() {
        return this.typeStore;
    }

    @Generated
    public RenderFlags getRenderFlags() {
        return this.renderFlags;
    }

    @Generated
    public ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    @Generated
    public Props getProps() {
        return this.props;
    }

    @Generated
    public Trees getTrees() {
        return this.trees;
    }
}

