/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.context;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import online.sharedtype.processor.context.EnumParsingUtils;
import online.sharedtype.processor.context.OutputTarget;
import online.sharedtype.processor.context.Props;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.support.exception.SharedTypeException;

public final class PropsFactory {
    private static final String DEFAULT_PROPERTIES_FILE = "sharedtype-default.properties";

    /*
     * Enabled aggressive exception aggregation
     */
    public static Props loadProps(@Nullable Path userPropertiesFile, @Nullable Map<String, String> userProperties) {
        ClassLoader classLoader = PropsFactory.class.getClassLoader();
        try (InputStream defaultPropsInputstream = classLoader.getResourceAsStream(DEFAULT_PROPERTIES_FILE);){
            Props props;
            block17: {
                InputStream userPropsInputstream = userPropertiesFile == null || Files.notExists(userPropertiesFile, new LinkOption[0]) ? null : Files.newInputStream(userPropertiesFile, new OpenOption[0]);
                try {
                    Properties properties = new Properties();
                    properties.load(defaultPropsInputstream);
                    if (userPropsInputstream != null) {
                        properties.load(userPropsInputstream);
                    }
                    if (userProperties != null) {
                        properties.putAll(userProperties);
                    }
                    properties.putAll((Map<?, ?>)System.getProperties());
                    Props props2 = PropsFactory.convertProps(properties);
                    if (props2.getTypescript().getOptionalFieldFormats().isEmpty()) {
                        throw new IllegalArgumentException("Props 'typescript.optional-field-format' cannot be empty.");
                    }
                    props = props2;
                    if (userPropsInputstream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (userPropsInputstream != null) {
                        try {
                            userPropsInputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                userPropsInputstream.close();
            }
            return props;
        }
        catch (Exception e) {
            throw new SharedTypeException("Failed to load properties.", e);
        }
    }

    private static Props convertProps(Properties properties) {
        Set<OutputTarget> targets = PropsFactory.parseEnumSet(properties, "sharedtype.targets", OutputTarget.class, OutputTarget::valueOf);
        return Props.builder().targets(targets).targetTypes(targets.stream().map(OutputTarget::getTargetType).filter(Objects::nonNull).collect(Collectors.toSet())).optionalAnnotations(PropsFactory.splitArray(properties.getProperty("sharedtype.optional-annotations"))).ignoreAnnotations(PropsFactory.splitArray(properties.getProperty("sharedtype.ignore-annotations"))).accessorAnnotations(PropsFactory.splitArray(properties.getProperty("sharedtype.accessor-annotations"))).enumValueAnnotations(PropsFactory.splitArray(properties.getProperty("sharedtype.enum-value-annotations"))).optionalContainerTypes(PropsFactory.splitArray(properties.getProperty("sharedtype.optional-container-types"))).accessorGetterPrefixes(PropsFactory.splitArray(properties.getProperty("sharedtype.accessor.getter-prefixes"))).arraylikeTypeQualifiedNames(PropsFactory.splitArray(properties.getProperty("sharedtype.array-like-types"))).maplikeTypeQualifiedNames(PropsFactory.splitArray(properties.getProperty("sharedtype.map-like-types"))).datetimelikeTypeQualifiedNames(PropsFactory.splitArray(properties.getProperty("sharedtype.datetime-like-types"))).ignoredTypeQualifiedNames(PropsFactory.splitArray(properties.getProperty("sharedtype.ignored-types"))).ignoredFieldNames(PropsFactory.splitArray(properties.getProperty("sharedtype.ignored-fields"))).constantNamespaced(PropsFactory.parseBoolean(properties, "sharedtype.constant-namespaced")).typescript(Props.Typescript.builder().outputFileName(properties.getProperty("sharedtype.typescript.output-file-name")).interfacePropertyDelimiter(properties.getProperty("sharedtype.typescript.interface-property-delimiter").charAt(0)).javaObjectMapType(properties.getProperty("sharedtype.typescript.java-object-map-type")).targetDatetimeTypeLiteral(properties.getProperty("sharedtype.typescript.target-datetime-type")).optionalFieldFormats(PropsFactory.parseEnumSet(properties, "sharedtype.typescript.optional-field-format", Props.Typescript.OptionalFieldFormat.class, Props.Typescript.OptionalFieldFormat::fromString)).enumFormat(PropsFactory.parseEnum(properties, "sharedtype.typescript.enum-format", Props.Typescript.EnumFormat::fromString)).fieldReadonlyType(PropsFactory.parseEnum(properties, "sharedtype.typescript.field-readonly-type", Props.Typescript.FieldReadonlyType::fromString)).typeMappings(PropsFactory.parseMap(properties, "sharedtype.typescript.type-mappings")).customCodePath(PropsFactory.resolvePath(properties, "sharedtype.typescript.custom-code-path")).build()).go(Props.Go.builder().outputFileName(properties.getProperty("sharedtype.go.output-file-name")).outputFilePackageName(properties.getProperty("sharedtype.go.output-file-package-name")).javaObjectMapType(properties.getProperty("sharedtype.go.java-object-map-type")).targetDatetimeTypeLiteral(properties.getProperty("sharedtype.go.target-datetime-type")).enumFormat(PropsFactory.parseEnum(properties, "sharedtype.go.enum-format", Props.Go.EnumFormat::fromString)).typeMappings(PropsFactory.parseMap(properties, "sharedtype.go.type-mappings")).customCodePath(PropsFactory.resolvePath(properties, "sharedtype.go.custom-code-path")).build()).rust(Props.Rust.builder().outputFileName(properties.getProperty("sharedtype.rust.output-file-name")).allowDeadcode(PropsFactory.parseBoolean(properties, "sharedtype.rust.allow-deadcode")).convertToSnakeCase(PropsFactory.parseBoolean(properties, "sharedtype.rust.convert-to-snake-case")).defaultTypeMacros(PropsFactory.splitArray(properties.getProperty("sharedtype.rust.default-macros-traits"))).targetDatetimeTypeLiteral(properties.getProperty("sharedtype.rust.target-datetime-type")).typeMappings(PropsFactory.parseMap(properties, "sharedtype.rust.type-mappings")).customCodePath(PropsFactory.resolvePath(properties, "sharedtype.rust.custom-code-path")).hasEnumValueTypeAlias(PropsFactory.parseBoolean(properties, "sharedtype.rust.enum-value-type-alias")).build()).build();
    }

    private static <T extends Enum<T>> Set<T> parseEnumSet(Properties properties, String propertyName, Class<T> type, Function<String, T> enumValueOf) {
        Set<String> trimmedElems = PropsFactory.splitArray(properties.getProperty(propertyName));
        try {
            return EnumParsingUtils.parseEnumSet(trimmedElems, type, enumValueOf);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failed to parse property '%s'", propertyName), e);
        }
    }

    private static Set<String> splitArray(String value) {
        String[] arr = value.split(",");
        LinkedHashSet<String> trimmedElems = new LinkedHashSet<String>(arr.length);
        for (String s : arr) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            trimmedElems.add(trimmed);
        }
        return trimmedElems;
    }

    private static boolean parseBoolean(Properties properties, String key) {
        String value = properties.getProperty(key);
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("property '%s', can only be 'true' or 'false', but it is '%s'.", key, value));
    }

    private static <T> Set<Class<? extends T>> parseClassSet(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        Set<String> propertyValues = PropsFactory.splitArray(value);
        LinkedHashSet<Class<T>> annotations = new LinkedHashSet<Class<T>>(propertyValues.size());
        for (String propertyValue : propertyValues) {
            try {
                annotations.add(PropsFactory.parseClass(propertyValue));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Invalid property %s=%s", propertyName, value), e);
            }
        }
        return annotations;
    }

    private static <T extends Enum<T>> T parseEnum(Properties properties, String propertyName, Function<String, T> fromString) {
        String value = properties.getProperty(propertyName);
        try {
            return (T)((Enum)fromString.apply(value));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid property %s=%s", propertyName, value), e);
        }
    }

    private static Map<String, String> parseMap(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        if (value == null || value.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] pairs = value.split(",");
        HashMap<String, String> map = new HashMap<String, String>(pairs.length);
        for (String pair : pairs) {
            String[] keyValue = pair.trim().split(":");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid property %s=%s, entries must be separated by commas and key-value by colons.", propertyName, value));
            }
            map.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return map;
    }

    private static Path resolvePath(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        if (value == null || value.isEmpty()) {
            return null;
        }
        Path path = Paths.get(value, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Invalid property %s=%s, file of path does not exist.", propertyName, path));
        }
        return path;
    }

    private static <T> Class<? extends T> parseClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }
}

