/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.EnumCtorIndex;
import online.sharedtype.processor.domain.Constants;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.support.annotation.Nullable;

public final class TypeStore {
    private final Map<String, List<TypeDef>> typeDefByQualifiedName = new HashMap<String, List<TypeDef>>();
    private final Map<TypeInfoKey, TypeInfo> typeInfoByKey = new HashMap<TypeInfoKey, TypeInfo>();
    private final Map<String, Config> typeConfig = new HashMap<String, Config>();
    private final Map<String, EnumCtorIndex> enumValueIndexByQualifiedName = new HashMap<String, EnumCtorIndex>();

    TypeStore() {
        for (Map.Entry<String, ConcreteTypeInfo> entry : Constants.PREDEFINED_OBJECT_TYPES.entrySet()) {
            this.saveTypeInfo(entry.getKey(), entry.getValue().typeArgs(), entry.getValue());
        }
    }

    public void saveTypeDef(String qualifiedName, TypeDef typeDef) {
        this.typeDefByQualifiedName.compute(qualifiedName, (k, v) -> {
            if (v == null) {
                v = new ArrayList<TypeDef>();
            }
            if (!v.contains(typeDef)) {
                v.add(typeDef);
            }
            return v;
        });
    }

    public void saveTypeInfo(String qualifiedName, List<? extends TypeInfo> typeArgs, TypeInfo typeInfo) {
        this.typeInfoByKey.put(new TypeInfoKey(qualifiedName, typeArgs), typeInfo);
    }

    public @Nullable List<TypeDef> getTypeDefs(String qualifiedName) {
        return this.typeDefByQualifiedName.get(qualifiedName);
    }

    public TypeInfo getTypeInfo(String qualifiedName, List<? extends TypeInfo> typeArgs) {
        return this.typeInfoByKey.get(new TypeInfoKey(qualifiedName, typeArgs));
    }

    public boolean containsTypeDef(String qualifiedName) {
        return this.typeDefByQualifiedName.containsKey(qualifiedName);
    }

    public void saveConfig(Config config) {
        this.typeConfig.put(config.getQualifiedName(), config);
    }

    public Config getConfig(TypeDef typeDef) {
        return this.typeConfig.get(typeDef.qualifiedName());
    }

    public void saveEnumValueIndex(String qualifiedName, EnumCtorIndex index) {
        this.enumValueIndexByQualifiedName.put(qualifiedName, index);
    }

    public @Nullable EnumCtorIndex getEnumValueIndex(String qualifiedName) {
        return this.enumValueIndexByQualifiedName.get(qualifiedName);
    }

    private static final class TypeInfoKey {
        final String qualifiedName;
        final List<? extends TypeInfo> typeArgs;

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeInfoKey)) {
                return false;
            }
            TypeInfoKey other = (TypeInfoKey)o;
            String this$qualifiedName = this.qualifiedName;
            String other$qualifiedName = other.qualifiedName;
            if (this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName)) {
                return false;
            }
            List<? extends TypeInfo> this$typeArgs = this.typeArgs;
            List<? extends TypeInfo> other$typeArgs = other.typeArgs;
            return !(this$typeArgs == null ? other$typeArgs != null : !((Object)this$typeArgs).equals(other$typeArgs));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $qualifiedName = this.qualifiedName;
            result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
            List<? extends TypeInfo> $typeArgs = this.typeArgs;
            result = result * 59 + ($typeArgs == null ? 43 : ((Object)$typeArgs).hashCode());
            return result;
        }

        @Generated
        public TypeInfoKey(String qualifiedName, List<? extends TypeInfo> typeArgs) {
            this.qualifiedName = qualifiedName;
            this.typeArgs = typeArgs;
        }
    }
}

