/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import online.sharedtype.SharedType;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;

public final class Constants {
    public static final String ANNOTATION_QUALIFIED_NAME = SharedType.class.getName();
    public static final ConcreteTypeInfo BOOLEAN_TYPE_INFO = ConcreteTypeInfo.ofPredefined("boolean", "boolean");
    public static final ConcreteTypeInfo BYTE_TYPE_INFO = ConcreteTypeInfo.ofPredefined("byte", "byte");
    public static final ConcreteTypeInfo CHAR_TYPE_INFO = ConcreteTypeInfo.ofPredefined("char", "char");
    public static final ConcreteTypeInfo DOUBLE_TYPE_INFO = ConcreteTypeInfo.ofPredefined("double", "double");
    public static final ConcreteTypeInfo FLOAT_TYPE_INFO = ConcreteTypeInfo.ofPredefined("float", "float");
    public static final ConcreteTypeInfo INT_TYPE_INFO = ConcreteTypeInfo.ofPredefined("int", "int");
    public static final ConcreteTypeInfo LONG_TYPE_INFO = ConcreteTypeInfo.ofPredefined("long", "long");
    public static final ConcreteTypeInfo SHORT_TYPE_INFO = ConcreteTypeInfo.ofPredefined("short", "short");
    public static final ConcreteTypeInfo BOXED_BOOLEAN_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Boolean", "Boolean");
    public static final ConcreteTypeInfo BOXED_BYTE_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Byte", "Byte");
    public static final ConcreteTypeInfo BOXED_CHAR_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Character", "Character");
    public static final ConcreteTypeInfo BOXED_DOUBLE_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Double", "Double");
    public static final ConcreteTypeInfo BOXED_FLOAT_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Float", "Float");
    public static final ConcreteTypeInfo BOXED_INT_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Integer", "Integer");
    public static final ConcreteTypeInfo BOXED_LONG_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Long", "Long");
    public static final ConcreteTypeInfo BOXED_SHORT_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Short", "Short");
    public static final ConcreteTypeInfo BIG_DECIMAL_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.math.BigDecimal", "BigDecimal");
    public static final ConcreteTypeInfo BIG_INTEGER_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.math.BigInteger", "BigInteger");
    public static final ConcreteTypeInfo STRING_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.String", "String");
    public static final ConcreteTypeInfo VOID_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Void", "Void");
    public static final ConcreteTypeInfo NULL_TYPE_INFO = ConcreteTypeInfo.ofPredefined("null", "null");
    public static final ConcreteTypeInfo OBJECT_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Object", "Object");
    public static final ConcreteTypeInfo CLASS_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Class", "Class");
    public static final ConcreteTypeInfo ENUM_TYPE_INFO = ConcreteTypeInfo.ofPredefined("java.lang.Enum", "Enum");
    public static final Map<TypeKind, ConcreteTypeInfo> PRIMITIVES = new HashMap<TypeKind, ConcreteTypeInfo>(8);
    public static final Map<String, ConcreteTypeInfo> PREDEFINED_OBJECT_TYPES;
    public static final Set<TypeInfo> LITERAL_TYPES;
    public static final Set<ConcreteTypeInfo> MATH_TYPES;
    public static final Set<String> MATH_TYPE_QUALIFIED_NAMES;

    private Constants() {
    }

    static {
        PRIMITIVES.put(TypeKind.BOOLEAN, BOOLEAN_TYPE_INFO);
        PRIMITIVES.put(TypeKind.BYTE, BYTE_TYPE_INFO);
        PRIMITIVES.put(TypeKind.CHAR, CHAR_TYPE_INFO);
        PRIMITIVES.put(TypeKind.DOUBLE, DOUBLE_TYPE_INFO);
        PRIMITIVES.put(TypeKind.FLOAT, FLOAT_TYPE_INFO);
        PRIMITIVES.put(TypeKind.INT, INT_TYPE_INFO);
        PRIMITIVES.put(TypeKind.LONG, LONG_TYPE_INFO);
        PRIMITIVES.put(TypeKind.SHORT, SHORT_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES = new HashMap<String, ConcreteTypeInfo>(16);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Boolean", BOXED_BOOLEAN_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Byte", BOXED_BYTE_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Character", BOXED_CHAR_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Double", BOXED_DOUBLE_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Float", BOXED_FLOAT_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Integer", BOXED_INT_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Long", BOXED_LONG_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Short", BOXED_SHORT_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.String", STRING_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Void", VOID_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Object", OBJECT_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Class", CLASS_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.lang.Enum", ENUM_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.math.BigDecimal", BIG_DECIMAL_TYPE_INFO);
        PREDEFINED_OBJECT_TYPES.put("java.math.BigInteger", BIG_INTEGER_TYPE_INFO);
        LITERAL_TYPES = new HashSet<TypeInfo>(14);
        LITERAL_TYPES.add(STRING_TYPE_INFO);
        LITERAL_TYPES.add(BYTE_TYPE_INFO);
        LITERAL_TYPES.add(SHORT_TYPE_INFO);
        LITERAL_TYPES.add(INT_TYPE_INFO);
        LITERAL_TYPES.add(LONG_TYPE_INFO);
        LITERAL_TYPES.add(FLOAT_TYPE_INFO);
        LITERAL_TYPES.add(DOUBLE_TYPE_INFO);
        LITERAL_TYPES.add(CHAR_TYPE_INFO);
        LITERAL_TYPES.add(BOXED_BYTE_TYPE_INFO);
        LITERAL_TYPES.add(BOXED_SHORT_TYPE_INFO);
        LITERAL_TYPES.add(BOXED_INT_TYPE_INFO);
        LITERAL_TYPES.add(BOXED_LONG_TYPE_INFO);
        LITERAL_TYPES.add(BOXED_FLOAT_TYPE_INFO);
        LITERAL_TYPES.add(BOXED_DOUBLE_TYPE_INFO);
        LITERAL_TYPES.add(BOXED_CHAR_TYPE_INFO);
        MATH_TYPES = new HashSet<ConcreteTypeInfo>(2);
        MATH_TYPES.add(BIG_DECIMAL_TYPE_INFO);
        MATH_TYPES.add(BIG_INTEGER_TYPE_INFO);
        MATH_TYPE_QUALIFIED_NAMES = new HashSet<String>(2);
        for (ConcreteTypeInfo mathType : MATH_TYPES) {
            MATH_TYPE_QUALIFIED_NAMES.add(mathType.qualifiedName());
        }
    }
}

