/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.domain.def;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import online.sharedtype.processor.domain.component.FieldComponentInfo;
import online.sharedtype.processor.domain.def.ConcreteTypeDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.domain.type.TypeVariableInfo;

public final class ClassDef
extends ConcreteTypeDef {
    private static final long serialVersionUID = 9052013791381913516L;
    private final String qualifiedName;
    private final String simpleName;
    private final List<FieldComponentInfo> components;
    private final List<TypeVariableInfo> typeVariables;
    private final List<TypeInfo> supertypes;
    private final Set<TypeDef> subtypes = new HashSet<TypeDef>();
    private final Set<ConcreteTypeInfo> typeInfoSet = new HashSet<ConcreteTypeInfo>();

    @Override
    public String qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String simpleName() {
        return this.simpleName;
    }

    public List<FieldComponentInfo> components() {
        return this.components;
    }

    public List<TypeVariableInfo> typeVariables() {
        return this.typeVariables;
    }

    @Override
    public List<TypeInfo> directSupertypes() {
        return this.supertypes;
    }

    public Set<TypeDef> directSubtypes() {
        return this.subtypes;
    }

    @Override
    public Set<ConcreteTypeInfo> typeInfoSet() {
        return this.typeInfoSet;
    }

    public void addSubtype(TypeDef subtype) {
        this.subtypes.add(subtype);
    }

    @Override
    public void linkTypeInfo(ConcreteTypeInfo typeInfo) {
        this.typeInfoSet.add(typeInfo);
    }

    public ClassDef reify(List<? extends TypeInfo> typeArgs) {
        int l = typeArgs.size();
        if (l != this.typeVariables.size()) {
            throw new IllegalArgumentException(String.format("Cannot reify %s against typeArgs: %s, type parameter sizes are different.", this, typeArgs));
        }
        if (l == 0) {
            return this;
        }
        HashMap<TypeVariableInfo, TypeInfo> mappings = new HashMap<TypeVariableInfo, TypeInfo>(l);
        for (int i = 0; i < l; ++i) {
            mappings.put(this.typeVariables.get(i), typeArgs.get(i));
        }
        List<FieldComponentInfo> reifiedComponents = this.components.stream().map(comp -> ((FieldComponentInfo.FieldComponentInfoBuilder)comp.toBuilder().type(comp.type().reify(mappings))).build()).collect(Collectors.toList());
        List<TypeInfo> reifiedSupertypes = this.supertypes.stream().map(supertype -> supertype.reify(mappings)).collect(Collectors.toList());
        return ((ClassDefBuilder)((ClassDefBuilder)this.toBuilder().components(reifiedComponents)).supertypes(reifiedSupertypes)).build();
    }

    @Override
    public boolean resolved() {
        for (FieldComponentInfo fieldComponentInfo : this.components) {
            if (fieldComponentInfo.resolved()) continue;
            return false;
        }
        for (TypeVariableInfo typeVariableInfo : this.typeVariables) {
            if (typeVariableInfo.resolved()) continue;
            return false;
        }
        for (TypeInfo supertype : this.supertypes) {
            if (supertype.resolved()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        ArrayList<String> rows = new ArrayList<String>(this.components.size() + 2);
        rows.add(String.format("%s%s%s {", this.qualifiedName, this.typeVariablesToString(), this.supertypesToString()));
        rows.addAll(this.components.stream().map(f -> String.format("  %s", f)).collect(Collectors.toList()));
        rows.add("}");
        return String.join((CharSequence)System.lineSeparator(), rows);
    }

    private String typeVariablesToString() {
        return this.typeVariables.isEmpty() ? "" : "<" + this.typeVariables.stream().map(TypeVariableInfo::toString).collect(Collectors.joining(",")) + ">";
    }

    private String supertypesToString() {
        if (this.supertypes.isEmpty()) {
            return "";
        }
        return " extends " + this.supertypes.stream().map(t -> t + (t.resolved() ? "" : "?")).collect(Collectors.joining(" & "));
    }

    @Generated
    private static List<FieldComponentInfo> $default$components() {
        return new ArrayList<FieldComponentInfo>();
    }

    @Generated
    private static List<TypeVariableInfo> $default$typeVariables() {
        return new ArrayList<TypeVariableInfo>();
    }

    @Generated
    private static List<TypeInfo> $default$supertypes() {
        return new ArrayList<TypeInfo>();
    }

    @Generated
    protected ClassDef(ClassDefBuilder<?, ?> b) {
        super(b);
        this.qualifiedName = ((ClassDefBuilder)b).qualifiedName;
        this.simpleName = ((ClassDefBuilder)b).simpleName;
        this.components = ((ClassDefBuilder)b).components$set ? ((ClassDefBuilder)b).components$value : ClassDef.$default$components();
        this.typeVariables = ((ClassDefBuilder)b).typeVariables$set ? ((ClassDefBuilder)b).typeVariables$value : ClassDef.$default$typeVariables();
        this.supertypes = ((ClassDefBuilder)b).supertypes$set ? ((ClassDefBuilder)b).supertypes$value : ClassDef.$default$supertypes();
    }

    @Generated
    public static ClassDefBuilder<?, ?> builder() {
        return new ClassDefBuilderImpl();
    }

    @Generated
    public ClassDefBuilder<?, ?> toBuilder() {
        return new ClassDefBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDef)) {
            return false;
        }
        ClassDef other = (ClassDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$qualifiedName = this.qualifiedName;
        String other$qualifiedName = other.qualifiedName;
        return !(this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassDef;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $qualifiedName = this.qualifiedName;
        result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
        return result;
    }

    @Generated
    public static abstract class ClassDefBuilder<C extends ClassDef, B extends ClassDefBuilder<C, B>>
    extends ConcreteTypeDef.ConcreteTypeDefBuilder<C, B> {
        @Generated
        private String qualifiedName;
        @Generated
        private String simpleName;
        @Generated
        private boolean components$set;
        @Generated
        private List<FieldComponentInfo> components$value;
        @Generated
        private boolean typeVariables$set;
        @Generated
        private List<TypeVariableInfo> typeVariables$value;
        @Generated
        private boolean supertypes$set;
        @Generated
        private List<TypeInfo> supertypes$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ClassDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ClassDef instance, ClassDefBuilder<?, ?> b) {
            b.qualifiedName(instance.qualifiedName);
            b.simpleName(instance.simpleName);
            b.components(instance.components);
            b.typeVariables(instance.typeVariables);
            b.supertypes(instance.supertypes);
        }

        @Generated
        public B qualifiedName(String qualifiedName) {
            this.qualifiedName = qualifiedName;
            return (B)this.self();
        }

        @Generated
        public B simpleName(String simpleName) {
            this.simpleName = simpleName;
            return (B)this.self();
        }

        @Generated
        public B components(List<FieldComponentInfo> components) {
            this.components$value = components;
            this.components$set = true;
            return (B)this.self();
        }

        @Generated
        public B typeVariables(List<TypeVariableInfo> typeVariables) {
            this.typeVariables$value = typeVariables;
            this.typeVariables$set = true;
            return (B)this.self();
        }

        @Generated
        public B supertypes(List<TypeInfo> supertypes) {
            this.supertypes$value = supertypes;
            this.supertypes$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ClassDef.ClassDefBuilder(super=" + super.toString() + ", qualifiedName=" + this.qualifiedName + ", simpleName=" + this.simpleName + ", components$value=" + this.components$value + ", typeVariables$value=" + this.typeVariables$value + ", supertypes$value=" + this.supertypes$value + ")";
        }
    }

    @Generated
    private static final class ClassDefBuilderImpl
    extends ClassDefBuilder<ClassDef, ClassDefBuilderImpl> {
        @Generated
        private ClassDefBuilderImpl() {
        }

        @Override
        @Generated
        protected ClassDefBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ClassDef build() {
            return new ClassDef(this);
        }
    }
}

