/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.domain.value;

import java.io.Serializable;
import online.sharedtype.processor.domain.Constants;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.value.EnumConstantValue;
import online.sharedtype.processor.domain.value.LiteralValue;

public interface ValueHolder
extends Serializable {
    public static final LiteralValue NULL = new LiteralValue(Constants.NULL_TYPE_INFO, null);

    public ConcreteTypeInfo getValueType();

    public Object getValue();

    default public String literalValue() {
        Object value = this.getValue();
        if (value instanceof CharSequence || value instanceof Character) {
            return String.format("\"%s\"", value);
        }
        return String.valueOf(value);
    }

    public static ValueHolder of(ConcreteTypeInfo valueType, Object value) {
        if (value instanceof ValueHolder) {
            return (ValueHolder)value;
        }
        return new LiteralValue(valueType, value);
    }

    public static EnumConstantValue ofEnum(ConcreteTypeInfo enumType, String enumConstantName, ConcreteTypeInfo valueType, Object value) {
        ConcreteTypeInfo actualValueType = valueType;
        Object actualValue = value;
        while (actualValue instanceof ValueHolder) {
            ValueHolder valueHolder = (ValueHolder)actualValue;
            actualValueType = valueHolder.getValueType();
            actualValue = valueHolder.getValue();
        }
        return new EnumConstantValue(enumType, enumConstantName, actualValueType, actualValue);
    }
}

