/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.component.AbstractComponentInfo;
import online.sharedtype.processor.domain.component.FieldComponentInfo;
import online.sharedtype.processor.domain.def.ClassDef;
import online.sharedtype.processor.domain.def.ConcreteTypeDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.domain.type.TypeVariableInfo;
import online.sharedtype.processor.parser.TypeDefParser;
import online.sharedtype.processor.parser.type.TypeInfoParser;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.support.utils.Tuple;
import online.sharedtype.processor.support.utils.Utils;

final class ClassTypeDefParser
implements TypeDefParser {
    private static final Set<String> SUPPORTED_ELEMENT_KINDS = new HashSet<String>(3);
    private final Context ctx;
    private final Types types;
    private final TypeInfoParser typeInfoParser;

    ClassTypeDefParser(Context ctx, TypeInfoParser typeInfoParser) {
        this.ctx = ctx;
        this.types = ctx.getProcessingEnv().getTypeUtils();
        this.typeInfoParser = typeInfoParser;
    }

    @Override
    public List<TypeDef> parse(TypeElement typeElement) {
        if (!SUPPORTED_ELEMENT_KINDS.contains(typeElement.getKind().name())) {
            return Collections.emptyList();
        }
        if (!this.isValidClassTypeElement(typeElement)) {
            return Collections.emptyList();
        }
        Config config = new Config(typeElement, this.ctx);
        this.ctx.getTypeStore().saveConfig(config);
        ConcreteTypeDef classDef = ((ClassDef.ClassDefBuilder)((ConcreteTypeDef.ConcreteTypeDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)ClassDef.builder().element(typeElement)).qualifiedName(config.getQualifiedName())).simpleName(config.getSimpleName())).annotated(config.isAnnotated())).build();
        ((ClassDef)classDef).typeVariables().addAll(this.parseTypeVariables(typeElement));
        ((ClassDef)classDef).components().addAll(this.parseComponents(typeElement, config, (ClassDef)classDef));
        ((ClassDef)classDef).directSupertypes().addAll(this.parseSupertypes(typeElement));
        TypeInfo typeInfo = this.typeInfoParser.parse(typeElement.asType(), typeElement);
        ((ConcreteTypeInfo)typeInfo).markShallowResolved(classDef);
        return Collections.singletonList(classDef);
    }

    private boolean isValidClassTypeElement(TypeElement typeElement) {
        if (typeElement.getNestingKind() != NestingKind.TOP_LEVEL && !typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.ctx.error(typeElement, "Class %s is not static, non-static inner class is not supported. Instance class may refer to its enclosing class's generic type without the type declaration on its own, which could break the generated code. Later version of SharedType may loosen this limitation.", typeElement);
            return false;
        }
        return true;
    }

    private List<TypeVariableInfo> parseTypeVariables(TypeElement typeElement) {
        List<? extends TypeParameterElement> typeParameters = typeElement.getTypeParameters();
        return typeParameters.stream().map(typeParameterElement -> TypeVariableInfo.builder().contextTypeQualifiedName(typeElement.getQualifiedName().toString()).name(typeParameterElement.getSimpleName().toString()).build()).collect(Collectors.toList());
    }

    private List<TypeInfo> parseSupertypes(TypeElement typeElement) {
        ArrayList<DeclaredType> supertypes = new ArrayList<DeclaredType>();
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass instanceof DeclaredType) {
            supertypes.add((DeclaredType)superclass);
        }
        List<? extends TypeMirror> interfaceTypes = typeElement.getInterfaces();
        for (TypeMirror typeMirror : interfaceTypes) {
            supertypes.add((DeclaredType)typeMirror);
        }
        ArrayList<TypeInfo> res = new ArrayList<TypeInfo>(supertypes.size());
        for (DeclaredType supertype : supertypes) {
            if (this.ctx.isIgnored(supertype.asElement())) continue;
            res.add(this.typeInfoParser.parse(supertype, typeElement));
        }
        return res;
    }

    private List<FieldComponentInfo> parseComponents(TypeElement typeElement, Config config, ClassDef classDef) {
        List<Tuple<Element, String>> componentElems = this.resolveComponents(typeElement, config);
        ArrayList<FieldComponentInfo> fields = new ArrayList<FieldComponentInfo>(componentElems.size());
        for (Tuple<Element, String> tuple : componentElems) {
            Element element = tuple.a();
            TypeInfo fieldTypeInfo = this.typeInfoParser.parse(element.asType(), typeElement);
            fieldTypeInfo.addReferencingType(classDef);
            AbstractComponentInfo fieldInfo = ((FieldComponentInfo.FieldComponentInfoBuilder)((FieldComponentInfo.FieldComponentInfoBuilder)((AbstractComponentInfo.AbstractComponentInfoBuilder)((FieldComponentInfo.FieldComponentInfoBuilder)FieldComponentInfo.builder().name(tuple.b())).optional(this.ctx.isOptionalAnnotated(element))).element(element)).type(fieldTypeInfo)).build();
            fields.add((FieldComponentInfo)fieldInfo);
        }
        return fields;
    }

    List<Tuple<Element, String>> resolveComponents(TypeElement typeElement, Config config) {
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        ArrayList<Tuple<Element, String>> res = new ArrayList<Tuple<Element, String>>(enclosedElements.size());
        NamesOfTypes uniqueNamesOfTypes = new NamesOfTypes(enclosedElements.size(), typeElement);
        boolean includeAccessors = config.includes(SharedType.ComponentType.ACCESSORS);
        boolean includeFields = config.includes(SharedType.ComponentType.FIELDS);
        Set instanceFieldNames = enclosedElements.stream().filter(e -> e.getKind() == ElementKind.FIELD && !e.getModifiers().contains((Object)Modifier.STATIC)).map(e -> e.getSimpleName().toString()).collect(Collectors.toSet());
        for (Element element : enclosedElements) {
            TypeMirror returnType;
            if (this.ctx.isIgnored(element)) continue;
            TypeMirror type = element.asType();
            String name = element.getSimpleName().toString();
            if (element.getKind() == ElementKind.FIELD && element instanceof VariableElement) {
                VariableElement variableElem = (VariableElement)element;
                if (uniqueNamesOfTypes.contains(name, type) || !includeFields || !instanceFieldNames.contains(name)) continue;
                res.add(Tuple.of(variableElem, name));
                uniqueNamesOfTypes.add(name, type);
                continue;
            }
            if (!includeAccessors || !(element instanceof ExecutableElement)) continue;
            ExecutableElement methodElem = (ExecutableElement)element;
            boolean explicitAccessor = this.ctx.isExplicitAccessor(methodElem);
            if (!ClassTypeDefParser.isZeroArgNonstaticMethod(methodElem)) {
                if (!explicitAccessor) continue;
                this.ctx.warn(methodElem, "%s.%s annotated as an accessor is not a zero-arg nonstatic method.", typeElement, methodElem);
                continue;
            }
            String baseName = this.getAccessorBaseName(name, instanceFieldNames.contains(name), explicitAccessor);
            if (baseName == null || uniqueNamesOfTypes.contains(baseName, returnType = methodElem.getReturnType())) continue;
            res.add(Tuple.of(methodElem, baseName));
            uniqueNamesOfTypes.add(baseName, returnType);
        }
        return res;
    }

    private static boolean isZeroArgNonstaticMethod(ExecutableElement componentElem) {
        if (componentElem.getKind() != ElementKind.METHOD || componentElem.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        return componentElem.getParameters().isEmpty();
    }

    private @Nullable String getAccessorBaseName(String name, boolean isFluentGetter, boolean isExplicitAccessor) {
        if (isFluentGetter) {
            return name;
        }
        for (String accessorGetterPrefix : this.ctx.getProps().getAccessorGetterPrefixes()) {
            if (!name.startsWith(accessorGetterPrefix)) continue;
            if (name.length() == accessorGetterPrefix.length()) {
                return null;
            }
            return Utils.substringAndUncapitalize(name, accessorGetterPrefix.length());
        }
        if (isExplicitAccessor) {
            return name;
        }
        return null;
    }

    static {
        SUPPORTED_ELEMENT_KINDS.add(ElementKind.CLASS.name());
        SUPPORTED_ELEMENT_KINDS.add(ElementKind.INTERFACE.name());
        SUPPORTED_ELEMENT_KINDS.add("RECORD");
    }

    private final class NamesOfTypes {
        private final TypeElement contextType;
        private final Map<String, TypeMirror> namesOfTypes;

        NamesOfTypes(int size, TypeElement contextType) {
            this.contextType = contextType;
            this.namesOfTypes = new HashMap<String, TypeMirror>(size);
        }

        boolean contains(String name, TypeMirror componentType) {
            TypeMirror type = this.namesOfTypes.get(name);
            if (type == null) {
                return false;
            }
            if (!ClassTypeDefParser.this.types.isSameType(type, componentType)) {
                ClassTypeDefParser.this.ctx.error(this.contextType, "Type %s has conflicting components with same name '%s', because they have different types '%s' and '%s', they cannot be merged.", this.contextType, name, type, componentType);
            }
            return true;
        }

        void add(String name, TypeMirror componentType) {
            this.namesOfTypes.put(name, componentType);
        }
    }
}

