/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.component.AbstractComponentInfo;
import online.sharedtype.processor.domain.component.ComponentInfo;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.parser.TypeDefParser;

final class CompositeTypeDefParser
implements TypeDefParser {
    private final Context ctx;
    private final List<TypeDefParser> parsers;

    @Override
    public List<TypeDef> parse(TypeElement typeElement) {
        if (this.ctx.isIgnored(typeElement)) {
            return Collections.emptyList();
        }
        String qualifiedName = typeElement.getQualifiedName().toString();
        List<TypeDef> cachedDef = this.ctx.getTypeStore().getTypeDefs(qualifiedName);
        if (cachedDef != null) {
            return new ArrayList<TypeDef>(cachedDef);
        }
        if (this.ctx.isArraylike(typeElement.asType())) {
            this.ctx.warn(typeElement, "Type '%s' is an array type, which cannot be parsed and emitted as a standalone type.", typeElement.getQualifiedName());
            return Collections.emptyList();
        }
        if (this.ctx.isMaplike(typeElement.asType())) {
            this.ctx.warn(typeElement, "Type '%s' is a map type, which cannot be parsed and emitted as a standalone type.", typeElement.getQualifiedName());
            return Collections.emptyList();
        }
        if (this.ctx.isDatetimelike(typeElement.asType())) {
            this.ctx.warn(typeElement, "Type '%s' is a datetime type, which cannot be parsed and emitted as a standalone type.", typeElement.getQualifiedName());
            return Collections.emptyList();
        }
        this.ctx.info("Processing: %s", typeElement.getQualifiedName());
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>();
        for (TypeDefParser typeDefParser : this.parsers) {
            List<TypeDef> parsedTypeDefs = typeDefParser.parse(typeElement);
            for (TypeDef parsedTypeDef : parsedTypeDefs) {
                this.ctx.getTypeStore().saveTypeDef(qualifiedName, parsedTypeDef);
                this.populateTagLiterals(parsedTypeDef);
            }
            typeDefs.addAll(parsedTypeDefs);
        }
        return typeDefs;
    }

    private void populateTagLiterals(TypeDef typeDef) {
        for (ComponentInfo componentInfo : typeDef.components()) {
            if (!(componentInfo instanceof AbstractComponentInfo)) continue;
            AbstractComponentInfo abstractComponentInfo = (AbstractComponentInfo)componentInfo;
            abstractComponentInfo.setTagLiterals(this.ctx.extractTagLiterals(abstractComponentInfo.getElement()));
        }
    }

    @Generated
    public CompositeTypeDefParser(Context ctx, List<TypeDefParser> parsers) {
        this.ctx = ctx;
        this.parsers = parsers;
    }
}

