/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.component.AbstractComponentInfo;
import online.sharedtype.processor.domain.component.ConstantField;
import online.sharedtype.processor.domain.def.ClassDef;
import online.sharedtype.processor.domain.def.ConstantNamespaceDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.value.ValueHolder;
import online.sharedtype.processor.parser.TypeDefParser;
import online.sharedtype.processor.parser.value.ValueParser;
import online.sharedtype.processor.support.exception.SharedTypeInternalError;

final class ConstantTypeDefParser
implements TypeDefParser {
    private static final Set<String> SUPPORTED_ELEMENT_KIND = new HashSet<String>(4);
    private final Context ctx;
    private final ValueParser valueParser;

    @Override
    public List<TypeDef> parse(TypeElement typeElement) {
        if (!SUPPORTED_ELEMENT_KIND.contains(typeElement.getKind().name())) {
            return Collections.emptyList();
        }
        if (this.ctx.getTrees() == null) {
            this.ctx.info(typeElement, "Skip parsing constants for type %s, because tree is not available.", typeElement);
            return Collections.emptyList();
        }
        String qualifiedName = typeElement.getQualifiedName().toString();
        List<TypeDef> cachedDefs = this.ctx.getTypeStore().getTypeDefs(qualifiedName);
        if (cachedDefs == null || cachedDefs.isEmpty()) {
            throw new SharedTypeInternalError("No main type def found for: " + qualifiedName);
        }
        TypeDef mainTypeDef = cachedDefs.get(0);
        if (ConstantTypeDefParser.shouldSkip(mainTypeDef)) {
            return Collections.emptyList();
        }
        Config config = this.ctx.getTypeStore().getConfig(mainTypeDef);
        if (!config.includes(SharedType.ComponentType.CONSTANTS)) {
            return Collections.emptyList();
        }
        ConstantNamespaceDef constantNamespaceDef = ConstantNamespaceDef.builder().element(typeElement).qualifiedName(qualifiedName).simpleName(config.getSimpleName()).build();
        for (Element element : typeElement.getEnclosedElements()) {
            if (this.ctx.isIgnored(element) || element.getKind() != ElementKind.FIELD || !element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            ValueHolder value = this.valueParser.resolve(element, typeElement);
            AbstractComponentInfo constantField = ((ConstantField.ConstantFieldBuilder)((ConstantField.ConstantFieldBuilder)((ConstantField.ConstantFieldBuilder)ConstantField.builder().name(element.getSimpleName().toString())).element(element)).value(value)).build();
            constantNamespaceDef.components().add((ConstantField)constantField);
        }
        if (constantNamespaceDef.components().isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(constantNamespaceDef);
    }

    private static boolean shouldSkip(TypeDef mainTypeDef) {
        if (mainTypeDef instanceof ClassDef) {
            ClassDef classDef = (ClassDef)mainTypeDef;
            return !classDef.isAnnotated();
        }
        return false;
    }

    @Generated
    public ConstantTypeDefParser(Context ctx, ValueParser valueParser) {
        this.ctx = ctx;
        this.valueParser = valueParser;
    }

    static {
        SUPPORTED_ELEMENT_KIND.add(ElementKind.CLASS.name());
        SUPPORTED_ELEMENT_KIND.add(ElementKind.INTERFACE.name());
        SUPPORTED_ELEMENT_KIND.add("RECORD");
        SUPPORTED_ELEMENT_KIND.add(ElementKind.ENUM.name());
    }
}

