/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import lombok.Generated;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.component.AbstractComponentInfo;
import online.sharedtype.processor.domain.component.EnumValueInfo;
import online.sharedtype.processor.domain.def.ConcreteTypeDef;
import online.sharedtype.processor.domain.def.EnumDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.domain.value.EnumConstantValue;
import online.sharedtype.processor.domain.value.ValueHolder;
import online.sharedtype.processor.parser.TypeDefParser;
import online.sharedtype.processor.parser.type.TypeInfoParser;
import online.sharedtype.processor.parser.value.ValueParser;

final class EnumTypeDefParser
implements TypeDefParser {
    private final Context ctx;
    private final TypeInfoParser typeInfoParser;
    private final ValueParser valueParser;

    @Override
    public List<TypeDef> parse(TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.ENUM) {
            return Collections.emptyList();
        }
        if (this.ctx.getTrees() == null) {
            this.ctx.info(typeElement, "Skip parsing enum %s, because tree is not available.", typeElement);
            return Collections.emptyList();
        }
        Config config = new Config(typeElement, this.ctx);
        this.ctx.getTypeStore().saveConfig(config);
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        ArrayList<VariableElement> enumConstantElems = new ArrayList<VariableElement>(enclosedElements.size());
        for (Element element : enclosedElements) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            enumConstantElems.add((VariableElement)element);
        }
        ConcreteTypeDef enumDef = ((EnumDef.EnumDefBuilder)((ConcreteTypeDef.ConcreteTypeDefBuilder)((EnumDef.EnumDefBuilder)((EnumDef.EnumDefBuilder)EnumDef.builder().element(typeElement)).qualifiedName(config.getQualifiedName())).simpleName(config.getSimpleName())).annotated(config.isAnnotated())).build();
        ((EnumDef)enumDef).components().addAll(this.parseEnumConstants(typeElement, enumConstantElems));
        TypeInfo typeInfo = this.typeInfoParser.parse(typeElement.asType(), typeElement);
        ((ConcreteTypeInfo)typeInfo).markShallowResolved(enumDef);
        return Collections.singletonList(enumDef);
    }

    private List<EnumValueInfo> parseEnumConstants(TypeElement enumTypeElement, List<VariableElement> enumConstants) {
        ArrayList<EnumValueInfo> res = new ArrayList<EnumValueInfo>(enumConstants.size());
        for (VariableElement enumConstant : enumConstants) {
            String name = enumConstant.getSimpleName().toString();
            ValueHolder value = this.valueParser.resolve(enumConstant, enumTypeElement);
            if (value instanceof EnumConstantValue) {
                res.add((EnumValueInfo)((EnumValueInfo.EnumValueInfoBuilder)((AbstractComponentInfo.AbstractComponentInfoBuilder)((EnumValueInfo.EnumValueInfoBuilder)EnumValueInfo.builder().name(name)).value((EnumConstantValue)value)).element(enumConstant)).build());
                continue;
            }
            this.ctx.warn(enumConstant, "Cannot resolve value for enum constant %s, value: '%s'", name, value);
        }
        return res;
    }

    @Generated
    public EnumTypeDefParser(Context ctx, TypeInfoParser typeInfoParser, ValueParser valueParser) {
        this.ctx = ctx;
        this.typeInfoParser = typeInfoParser;
        this.valueParser = valueParser;
    }
}

