/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser.type;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.TypeStore;
import online.sharedtype.processor.domain.Constants;
import online.sharedtype.processor.domain.type.ArrayTypeInfo;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.DateTimeInfo;
import online.sharedtype.processor.domain.type.MapTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.domain.type.TypeVariableInfo;
import online.sharedtype.processor.parser.type.TypeInfoParser;
import online.sharedtype.processor.support.Preconditions;
import online.sharedtype.processor.support.exception.SharedTypeException;
import online.sharedtype.processor.support.exception.SharedTypeInternalError;

final class TypeInfoParserImpl
implements TypeInfoParser {
    private final Context ctx;
    private final TypeStore typeStore;
    private final Types types;

    TypeInfoParserImpl(Context ctx) {
        this.ctx = ctx;
        this.typeStore = ctx.getTypeStore();
        this.types = ctx.getProcessingEnv().getTypeUtils();
    }

    @Override
    public TypeInfo parse(TypeMirror typeMirror, TypeElement ctxTypeElement) {
        TypeKind typeKind = typeMirror.getKind();
        if (typeKind.isPrimitive()) {
            return Constants.PRIMITIVES.get((Object)typeKind);
        }
        if (typeKind == TypeKind.ARRAY) {
            return new ArrayTypeInfo(this.parse(((ArrayType)typeMirror).getComponentType(), ctxTypeElement));
        }
        if (typeKind == TypeKind.DECLARED) {
            return this.parseDeclared((DeclaredType)typeMirror, ctxTypeElement);
        }
        if (typeKind == TypeKind.TYPEVAR) {
            return this.parseTypeVariable((TypeVariable)typeMirror, ctxTypeElement);
        }
        if (typeKind == TypeKind.EXECUTABLE) {
            return this.parse(((ExecutableType)typeMirror).getReturnType(), ctxTypeElement);
        }
        if (typeKind == TypeKind.WILDCARD) {
            throw new SharedTypeException(String.format("Unsupported type: %s, typeKind: %s, contextType: %s. SharedType currently does not support wildcard generic types. If it's from a dependency type, consider ignore it via global properties.", new Object[]{typeMirror, typeKind, ctxTypeElement}));
        }
        if (typeKind == TypeKind.ERROR) {
            this.ctx.error(ctxTypeElement, "Failed to parse type '%s'. This is possibly because the type is not visible in the scope, if JPMS is used to resolve dependencies, check if it is on module path.", typeMirror);
            return TypeInfo.NO_TYPE_INFO;
        }
        throw new SharedTypeInternalError(String.format("Unsupported type: %s, typeKind: %s, contextType: %s. If it's from a dependency type, consider ignore it via global properties.", new Object[]{typeMirror, typeKind, ctxTypeElement}));
    }

    private TypeInfo parseDeclared(DeclaredType declaredType, TypeElement ctxTypeElement) {
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String qualifiedName = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        List<TypeMirror> typeArgs = declaredType.getTypeArguments();
        int arrayStack = 0;
        TypeMirror currentType = declaredType;
        TypeInfo typeInfo = null;
        while (this.ctx.isArraylike(currentType)) {
            ++arrayStack;
            if ((currentType = this.locateArrayComponentType(currentType)) instanceof DeclaredType) {
                TypeMirror argDeclaredType = currentType;
                TypeElement element = (TypeElement)argDeclaredType.asElement();
                qualifiedName = element.getQualifiedName().toString();
                simpleName = element.getSimpleName().toString();
                typeArgs = argDeclaredType.getTypeArguments();
                continue;
            }
            if (!(currentType instanceof TypeVariable)) continue;
            TypeVariable argTypeVariable = (TypeVariable)currentType;
            TypeVariableInfo typeVarInfo = this.parseTypeVariable(argTypeVariable, ctxTypeElement);
            qualifiedName = typeVarInfo.qualifiedName();
            simpleName = typeVarInfo.name();
            typeArgs = Collections.emptyList();
            typeInfo = typeVarInfo;
            break;
        }
        List<TypeInfo> parsedTypeArgs = typeArgs.stream().map(typeArg -> this.parse((TypeMirror)typeArg, ctxTypeElement)).collect(Collectors.toList());
        if (typeInfo == null) {
            typeInfo = this.typeStore.getTypeInfo(qualifiedName, parsedTypeArgs);
        }
        if (typeInfo == null && this.ctx.isDatetimelike(currentType)) {
            typeInfo = new DateTimeInfo(qualifiedName);
        }
        if (typeInfo == null && this.ctx.isMaplike(currentType) && currentType instanceof DeclaredType) {
            DeclaredType maplikeType = (DeclaredType)currentType;
            typeInfo = this.buildMapTypeInfo(maplikeType, ctxTypeElement);
        }
        if (typeInfo == null) {
            boolean resolved = this.typeStore.containsTypeDef(qualifiedName) || this.ctx.isOptionalType(qualifiedName);
            typeInfo = ConcreteTypeInfo.builder().qualifiedName(qualifiedName).simpleName(simpleName).typeArgs(parsedTypeArgs).kind(this.parseKind(currentType)).resolved(resolved).build();
            this.typeStore.saveTypeInfo(qualifiedName, parsedTypeArgs, typeInfo);
        }
        while (arrayStack > 0) {
            typeInfo = new ArrayTypeInfo(typeInfo);
            --arrayStack;
        }
        return typeInfo;
    }

    private ConcreteTypeInfo.Kind parseKind(TypeMirror typeMirror) {
        if (this.ctx.isEnumType(typeMirror)) {
            return ConcreteTypeInfo.Kind.ENUM;
        }
        return ConcreteTypeInfo.Kind.CLASS;
    }

    private TypeVariableInfo parseTypeVariable(TypeVariable typeVariable, TypeElement ctxTypeElement) {
        String simpleName;
        String contextTypeQualifiedName = ctxTypeElement.getQualifiedName().toString();
        String qualifiedName = TypeVariableInfo.concatQualifiedName(contextTypeQualifiedName, simpleName = typeVariable.asElement().getSimpleName().toString());
        TypeInfo typeInfo = this.typeStore.getTypeInfo(qualifiedName, Collections.emptyList());
        if (typeInfo != null) {
            return (TypeVariableInfo)typeInfo;
        }
        typeInfo = TypeVariableInfo.builder().contextTypeQualifiedName(contextTypeQualifiedName).name(simpleName).qualifiedName(qualifiedName).build();
        this.typeStore.saveTypeInfo(qualifiedName, Collections.emptyList(), typeInfo);
        return (TypeVariableInfo)typeInfo;
    }

    private TypeMirror locateArrayComponentType(TypeMirror typeMirror) {
        TypeMirror cur = typeMirror;
        int depth = 0;
        while (!this.ctx.isTopArrayType(cur)) {
            for (TypeMirror typeMirror2 : this.types.directSupertypes(cur)) {
                if (!this.ctx.isArraylike(typeMirror2)) continue;
                cur = typeMirror2;
                break;
            }
            if (depth++ <= 100) continue;
            throw new SharedTypeInternalError("Array type hierarchy exceed max depth: " + typeMirror);
        }
        List<? extends TypeMirror> typeArgs = ((DeclaredType)cur).getTypeArguments();
        Preconditions.checkArgument(typeArgs.size() == 1, "Array type must have exactly one type argument, but got: %s, type: %s", typeArgs.size(), typeMirror);
        return typeArgs.get(0);
    }

    private TypeInfo buildMapTypeInfo(DeclaredType maplikeType, TypeElement ctxTypeElement) {
        String baseMapTypeQualifiedName;
        ArrayDeque<DeclaredType> queue = new ArrayDeque<DeclaredType>();
        DeclaredType baseMapType = maplikeType;
        while (true) {
            baseMapTypeQualifiedName = this.ctx.getTypeQualifiedName(baseMapType);
            if (this.ctx.getProps().getMaplikeTypeQualifiedNames().contains(baseMapTypeQualifiedName)) break;
            for (TypeMirror typeMirror : this.types.directSupertypes(baseMapType)) {
                if (!(typeMirror instanceof DeclaredType)) continue;
                queue.add((DeclaredType)typeMirror);
            }
            baseMapType = Preconditions.requireNonNull((DeclaredType)queue.poll(), "Cannot find a qualified type name of a map-like type: %s", maplikeType);
        }
        List<? extends TypeMirror> typeArgs = baseMapType.getTypeArguments();
        if (typeArgs.size() != 2) {
            this.ctx.error(ctxTypeElement, "Base Map type must have 2 type arguments, with first as the key type and the second as the value type,but is %s, when trying to build expression for type: %s", baseMapType, maplikeType);
            return TypeInfo.NO_TYPE_INFO;
        }
        TypeInfo typeInfo = this.parse(typeArgs.get(0), ctxTypeElement);
        TypeInfo valueType = this.parse(typeArgs.get(1), ctxTypeElement);
        return MapTypeInfo.builder().baseMapTypeQualifiedName(baseMapTypeQualifiedName).qualifiedName(this.ctx.getTypeQualifiedName(maplikeType)).keyType(typeInfo).valueType(valueType).build();
    }
}

