/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser.value;

import java.util.EnumMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import online.sharedtype.processor.domain.value.ValueHolder;
import online.sharedtype.processor.parser.value.ValueParser;
import online.sharedtype.processor.support.exception.SharedTypeInternalError;

final class CompositeValueParser
implements ValueParser {
    private final Map<ElementKind, ValueParser> resolvers = new EnumMap<ElementKind, ValueParser>(ElementKind.class);

    CompositeValueParser() {
    }

    void registerResolver(ElementKind kind, ValueParser resolver) {
        this.resolvers.put(kind, resolver);
    }

    @Override
    public ValueHolder resolve(Element element, TypeElement ctxTypeElement) {
        ValueParser resolver = this.resolvers.get((Object)element.getKind());
        if (resolver != null) {
            return resolver.resolve(element, ctxTypeElement);
        }
        throw new SharedTypeInternalError(String.format("Unable to resolve value for element '%s', unsupported element kind: %s", new Object[]{element, element.getKind()}));
    }
}

