/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser.value;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import lombok.Generated;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.EnumCtorIndex;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.domain.value.ValueHolder;
import online.sharedtype.processor.parser.type.TypeInfoParser;
import online.sharedtype.processor.parser.value.ValueParser;
import online.sharedtype.processor.parser.value.ValueResolveContext;
import online.sharedtype.processor.parser.value.ValueResolverBackend;
import online.sharedtype.processor.support.exception.SharedTypeException;
import online.sharedtype.processor.support.exception.SharedTypeInternalError;
import online.sharedtype.processor.support.utils.Utils;

final class EnumValueParser
implements ValueParser {
    private final Context ctx;
    private final TypeInfoParser typeInfoParser;
    private final ValueResolverBackend valueResolverBackend;

    @Override
    public ValueHolder resolve(Element enumConstantElement, TypeElement enumTypeElement) {
        VariableElement enumConstant = (VariableElement)enumConstantElement;
        String enumConstantName = enumConstant.getSimpleName().toString();
        EnumCtorIndex ctorArgIdx = this.resolveCtorIndex(enumTypeElement);
        ConcreteTypeInfo enumTypeInfo = (ConcreteTypeInfo)this.typeInfoParser.parse(enumTypeElement.asType(), enumTypeElement);
        if (ctorArgIdx == EnumCtorIndex.NONE) {
            return ValueHolder.ofEnum(enumTypeInfo, enumConstantName, enumTypeInfo, enumConstantName);
        }
        Tree tree = this.ctx.getTrees().getTree(enumConstant);
        if (tree instanceof VariableTree) {
            VariableTree variableTree = (VariableTree)tree;
            Object value = this.resolveValue(enumTypeElement, enumTypeElement, variableTree, ctorArgIdx.getIdx());
            ConcreteTypeInfo valueType = null;
            while (value instanceof ValueHolder) {
                ValueHolder valueHolder = (ValueHolder)value;
                value = valueHolder.getValue();
                valueType = valueHolder.getValueType();
            }
            if (valueType == null) {
                TypeInfo fieldTypeInfo = this.typeInfoParser.parse(ctorArgIdx.getField().asType(), enumTypeElement);
                if (fieldTypeInfo instanceof ConcreteTypeInfo) {
                    valueType = (ConcreteTypeInfo)fieldTypeInfo;
                } else {
                    this.ctx.error(enumConstant, "Complex field types are not supported for value resolving. Only literal types or references are supported, the type is '%s'.", ctorArgIdx.getField().asType());
                    return ValueHolder.NULL;
                }
            }
            return ValueHolder.ofEnum(enumTypeInfo, enumConstantName, valueType, value);
        }
        if (tree != null) {
            throw new SharedTypeInternalError(String.format("Unsupported tree during parsing enum %s, kind: %s, tree: %s, element: %s", new Object[]{enumTypeElement, tree.getKind(), tree, enumConstant}));
        }
        this.ctx.error(enumConstant, "Literal value cannot be parsed from enum constant: %s of enum %s, because source tree from the element is null. This could mean at the time of the annotation processing, the source tree was not available. Is this class from a dependency jar/compiled class file? Please refer to the documentation for more information.", enumConstant, enumTypeElement);
        return ValueHolder.NULL;
    }

    private Object resolveValue(Element enumConstantElement, TypeElement enumTypeElement, VariableTree tree, int ctorArgIdx) {
        ExpressionTree init = tree.getInitializer();
        if (init instanceof NewClassTree) {
            NewClassTree newClassTree = (NewClassTree)init;
            try {
                ExpressionTree argTree = newClassTree.getArguments().get(ctorArgIdx);
                ValueResolveContext valueResolveContext = ValueResolveContext.builder(this.ctx).enclosingTypeElement(enumTypeElement).fieldElement(enumConstantElement).tree(argTree).build();
                return this.valueResolverBackend.recursivelyResolve(valueResolveContext);
            }
            catch (IndexOutOfBoundsException e) {
                throw new SharedTypeInternalError(String.format("Initializer in enum %s has incorrect number of arguments: %s in tree: %s, argIndex: %s", enumTypeElement, init, tree, ctorArgIdx));
            }
            catch (SharedTypeException e) {
                this.ctx.error(enumConstantElement, "Failed to parse argument value at index %s. Tree: %s Error message: %s", ctorArgIdx, tree, e.getMessage());
                return null;
            }
        }
        throw new SharedTypeInternalError(String.format("Unsupported initializer in enum %s: %s in tree: %s", enumTypeElement, init, tree));
    }

    EnumCtorIndex resolveCtorIndex(TypeElement enumTypeElement) {
        EnumCtorIndex cachedIdx = this.ctx.getTypeStore().getEnumValueIndex(enumTypeElement.getQualifiedName().toString());
        if (cachedIdx != null) {
            return cachedIdx;
        }
        List<VariableElement> instanceFields = Utils.allInstanceFields(enumTypeElement);
        EnumCtorIndex idx = EnumCtorIndex.NONE;
        for (int i = 0; i < instanceFields.size(); ++i) {
            VariableElement field = instanceFields.get(i);
            if (!this.ctx.isAnnotatedAsEnumValue(field)) continue;
            if (idx != EnumCtorIndex.NONE) {
                this.ctx.error(field, "Multiple enum values in enum %s, only one field can be annotated as enum value.", enumTypeElement);
            }
            idx = new EnumCtorIndex(i, field);
        }
        this.ctx.getTypeStore().saveEnumValueIndex(enumTypeElement.getQualifiedName().toString(), idx);
        return idx;
    }

    @Generated
    public EnumValueParser(Context ctx, TypeInfoParser typeInfoParser, ValueResolverBackend valueResolverBackend) {
        this.ctx = ctx;
        this.typeInfoParser = typeInfoParser;
        this.valueResolverBackend = valueResolverBackend;
    }
}

