/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser.value;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import lombok.Generated;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.support.exception.SharedTypeException;

final class ValueResolveContext {
    private final Context ctx;
    private final Trees trees;
    private final Elements elements;
    private final Types types;
    private final Element fieldElement;
    private final Tree tree;
    private final TypeElement enclosingTypeElement;

    ValueResolveContext(Context ctx, Element fieldElement, Tree tree, TypeElement enclosingTypeElement) {
        this.ctx = ctx;
        this.trees = ctx.getTrees();
        this.elements = ctx.getProcessingEnv().getElementUtils();
        this.types = ctx.getProcessingEnv().getTypeUtils();
        this.fieldElement = fieldElement;
        this.tree = tree;
        this.enclosingTypeElement = enclosingTypeElement;
    }

    public static Builder builder(Context ctx) {
        return new Builder(ctx);
    }

    Scope getScope() {
        TreePath treePath = this.trees.getPath(this.enclosingTypeElement);
        return treePath == null ? null : this.trees.getScope(treePath);
    }

    BlockTree getStaticBlock() {
        for (Tree tree : this.trees.getTree(this.enclosingTypeElement).getMembers()) {
            BlockTree blockTree;
            if (tree.getKind() != Tree.Kind.BLOCK || !(blockTree = (BlockTree)tree).isStatic()) continue;
            return blockTree;
        }
        throw new SharedTypeException("No static block found for type: " + this.enclosingTypeElement);
    }

    PackageElement getPackageElement() {
        return this.elements.getPackageOf(this.enclosingTypeElement);
    }

    public Builder toBuilder() {
        return new Builder(this.ctx).fieldElement(this.fieldElement).tree(this.tree).enclosingTypeElement(this.enclosingTypeElement);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueResolveContext)) {
            return false;
        }
        ValueResolveContext other = (ValueResolveContext)o;
        Element this$fieldElement = this.getFieldElement();
        Element other$fieldElement = other.getFieldElement();
        if (this$fieldElement == null ? other$fieldElement != null : !((Object)this$fieldElement).equals(other$fieldElement)) {
            return false;
        }
        Tree this$tree = this.getTree();
        Tree other$tree = other.getTree();
        if (this$tree == null ? other$tree != null : !this$tree.equals(other$tree)) {
            return false;
        }
        TypeElement this$enclosingTypeElement = this.getEnclosingTypeElement();
        TypeElement other$enclosingTypeElement = other.getEnclosingTypeElement();
        return !(this$enclosingTypeElement == null ? other$enclosingTypeElement != null : !this$enclosingTypeElement.equals(other$enclosingTypeElement));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Element $fieldElement = this.getFieldElement();
        result = result * 59 + ($fieldElement == null ? 43 : ((Object)$fieldElement).hashCode());
        Tree $tree = this.getTree();
        result = result * 59 + ($tree == null ? 43 : $tree.hashCode());
        TypeElement $enclosingTypeElement = this.getEnclosingTypeElement();
        result = result * 59 + ($enclosingTypeElement == null ? 43 : $enclosingTypeElement.hashCode());
        return result;
    }

    @Generated
    public Context getCtx() {
        return this.ctx;
    }

    @Generated
    public Trees getTrees() {
        return this.trees;
    }

    @Generated
    public Elements getElements() {
        return this.elements;
    }

    @Generated
    public Types getTypes() {
        return this.types;
    }

    @Generated
    public Element getFieldElement() {
        return this.fieldElement;
    }

    @Generated
    public Tree getTree() {
        return this.tree;
    }

    @Generated
    public TypeElement getEnclosingTypeElement() {
        return this.enclosingTypeElement;
    }

    static final class Builder {
        private final Context ctx;
        private Element fieldElement;
        private Tree tree;
        private TypeElement enclosingTypeElement;

        public Builder fieldElement(Element fieldElement) {
            this.fieldElement = fieldElement;
            return this;
        }

        public Builder tree(Tree tree) {
            this.tree = tree;
            return this;
        }

        public Builder enclosingTypeElement(TypeElement enclosingTypeElement) {
            this.enclosingTypeElement = enclosingTypeElement;
            return this;
        }

        public ValueResolveContext build() {
            return new ValueResolveContext(this.ctx, this.fieldElement, this.tree, this.enclosingTypeElement);
        }

        @Generated
        public String toString() {
            return "ValueResolveContext.Builder(ctx=" + this.ctx + ", fieldElement=" + this.fieldElement + ", tree=" + this.tree + ", enclosingTypeElement=" + this.enclosingTypeElement + ")";
        }

        @Generated
        public Builder(Context ctx) {
            this.ctx = ctx;
        }
    }
}

