/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser.value;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.support.exception.SharedTypeException;
import online.sharedtype.processor.support.exception.SharedTypeInternalError;

final class ValueResolveUtils {
    private static final Set<String> TO_FIND_ENCLOSED_ELEMENT_KIND_SET = new HashSet<String>(6);

    static @Nullable TypeElement getEnclosingTypeElement(Element element) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement instanceof TypeElement) {
            return (TypeElement)enclosingElement;
        }
        return null;
    }

    static @Nullable ExpressionTree getValueTree(Tree tree, TypeElement enclosingTypeElement) {
        ExpressionTree valueTree;
        if (tree instanceof LiteralTree) {
            valueTree = (LiteralTree)tree;
        } else if (tree instanceof VariableTree) {
            valueTree = ((VariableTree)tree).getInitializer();
        } else if (tree instanceof AssignmentTree) {
            valueTree = ((AssignmentTree)tree).getExpression();
        } else if (tree instanceof IdentifierTree) {
            valueTree = (IdentifierTree)tree;
        } else if (tree instanceof MemberSelectTree) {
            valueTree = (MemberSelectTree)tree;
        } else {
            throw new SharedTypeInternalError(String.format("Not supported tree type for constant field parsing. Field: '%s' of kind '%s' and type '%s' in '%s'", new Object[]{tree, tree.getKind(), tree.getClass().getSimpleName(), enclosingTypeElement}));
        }
        return valueTree;
    }

    static @Nullable Element findElementInLocalScope(@Nullable Scope scope, String name, TypeElement enclosingTypeElement) {
        Element referencedElement = ValueResolveUtils.findElementInTree(scope, name);
        if (referencedElement == null) {
            referencedElement = ValueResolveUtils.findEnclosedElement(enclosingTypeElement, name);
        }
        return referencedElement;
    }

    static @Nullable Element findEnclosedElement(Element enclosingElement, String name) {
        for (Element element : enclosingElement.getEnclosedElements()) {
            if (!element.getSimpleName().contentEquals(name)) continue;
            if (!TO_FIND_ENCLOSED_ELEMENT_KIND_SET.contains(element.getKind().name())) {
                throw new SharedTypeException(String.format("Enclosed field '%s' is of element kind '%s': element '%s' in '%s', which is not supported. Supported element kinds: %s.", new Object[]{name, element.getKind(), element, enclosingElement, String.join((CharSequence)", ", TO_FIND_ENCLOSED_ELEMENT_KIND_SET)}));
            }
            return element;
        }
        return null;
    }

    private static @Nullable Element findElementInTree(Scope scope, String name) {
        for (Scope curScope = scope; curScope != null; curScope = curScope.getEnclosingScope()) {
            for (Element element : curScope.getLocalElements()) {
                if (!element.getSimpleName().contentEquals(name) || !TO_FIND_ENCLOSED_ELEMENT_KIND_SET.contains(element.getKind().name())) continue;
                return element;
            }
        }
        return null;
    }

    @Generated
    private ValueResolveUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        TO_FIND_ENCLOSED_ELEMENT_KIND_SET.add(ElementKind.ENUM.name());
        TO_FIND_ENCLOSED_ELEMENT_KIND_SET.add(ElementKind.CLASS.name());
        TO_FIND_ENCLOSED_ELEMENT_KIND_SET.add(ElementKind.INTERFACE.name());
        TO_FIND_ENCLOSED_ELEMENT_KIND_SET.add("RECORD");
        TO_FIND_ENCLOSED_ELEMENT_KIND_SET.add(ElementKind.FIELD.name());
        TO_FIND_ENCLOSED_ELEMENT_KIND_SET.add(ElementKind.ENUM_CONSTANT.name());
    }
}

