/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.parser.value;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;
import online.sharedtype.processor.domain.Constants;
import online.sharedtype.processor.parser.value.ValueParser;
import online.sharedtype.processor.parser.value.ValueResolveContext;
import online.sharedtype.processor.parser.value.ValueResolveUtils;
import online.sharedtype.processor.parser.value.ValueResolverBackend;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.support.exception.SharedTypeException;

final class ValueResolverBackendImpl
implements ValueResolverBackend {
    private final ValueParser valueParser;

    @Override
    public Object recursivelyResolve(ValueResolveContext parsingContext) {
        ExpressionTree valueTree = ValueResolveUtils.getValueTree(parsingContext.getTree(), parsingContext.getEnclosingTypeElement());
        if (valueTree instanceof LiteralTree) {
            return ((LiteralTree)valueTree).getValue();
        }
        if (valueTree instanceof NewClassTree) {
            NewClassTree newClassTree = (NewClassTree)valueTree;
            return this.resolveMathTypeNewClassValue(newClassTree, parsingContext);
        }
        Tree tree = parsingContext.getTree();
        TypeElement enclosingTypeElement = parsingContext.getEnclosingTypeElement();
        if (valueTree == null && tree.getKind() == Tree.Kind.VARIABLE) {
            VariableTree variableTree = (VariableTree)tree;
            return this.resolveEvaluationInStaticBlock(variableTree.getName(), parsingContext);
        }
        if (valueTree == null) {
            throw new SharedTypeException(String.format("Cannot find value for tree: '%s' in '%s'", tree, enclosingTypeElement));
        }
        Element referencedFieldElement = ValueResolverBackendImpl.recursivelyResolveReferencedElement(valueTree, parsingContext);
        TypeElement referencedFieldEnclosingTypeElement = ValueResolveUtils.getEnclosingTypeElement(referencedFieldElement);
        if (referencedFieldEnclosingTypeElement == null) {
            throw new SharedTypeException(String.format("Cannot find enclosing type for field: '%s'", referencedFieldElement));
        }
        if (referencedFieldElement.getKind() == ElementKind.ENUM_CONSTANT) {
            return this.valueParser.resolve(referencedFieldElement, referencedFieldEnclosingTypeElement);
        }
        ValueResolveContext nextParsingContext = parsingContext.toBuilder().tree(parsingContext.getTrees().getTree(referencedFieldElement)).enclosingTypeElement(referencedFieldEnclosingTypeElement).build();
        return this.recursivelyResolve(nextParsingContext);
    }

    private Object resolveEvaluationInStaticBlock(Name variableName, ValueResolveContext parsingContext) {
        BlockTree blockTree = parsingContext.getStaticBlock();
        for (StatementTree statementTree : blockTree.getStatements()) {
            IdentifierTree identifierTree;
            AssignmentTree assignmentTree;
            ExpressionTree variableTree;
            ExpressionStatementTree expressionStatementTree;
            ExpressionTree expressionTree;
            if (statementTree.getKind() != Tree.Kind.EXPRESSION_STATEMENT || (expressionTree = (expressionStatementTree = (ExpressionStatementTree)statementTree).getExpression()).getKind() != Tree.Kind.ASSIGNMENT || !((variableTree = (assignmentTree = (AssignmentTree)expressionTree).getVariable()) instanceof IdentifierTree) || !variableName.contentEquals((identifierTree = (IdentifierTree)variableTree).getName())) continue;
            ValueResolveContext nextParsingContext = parsingContext.toBuilder().tree(assignmentTree.getExpression()).build();
            return this.recursivelyResolve(nextParsingContext);
        }
        throw new SharedTypeException(String.format("No static evaluation found for constant field: %s in %s", parsingContext.getFieldElement(), parsingContext.getEnclosingTypeElement()));
    }

    private String resolveMathTypeNewClassValue(NewClassTree newClassTree, ValueResolveContext parsingContext) {
        ExpressionTree typeIdentifierTree = newClassTree.getIdentifier();
        Element referencedElement = ValueResolverBackendImpl.recursivelyResolveReferencedElement(typeIdentifierTree, parsingContext);
        if (!(referencedElement instanceof TypeElement)) {
            throw new SharedTypeException(String.format("A new class type element must be typeElement, but found: %s in %s, new class tree: %s", referencedElement, parsingContext.getEnclosingTypeElement(), typeIdentifierTree));
        }
        TypeElement typeElement = (TypeElement)referencedElement;
        if (!Constants.MATH_TYPE_QUALIFIED_NAMES.contains(typeElement.getQualifiedName().toString())) {
            throw new SharedTypeException(String.format("Math type must be one of %s, but found: %s", Constants.MATH_TYPE_QUALIFIED_NAMES, typeElement));
        }
        List<? extends ExpressionTree> arguments = newClassTree.getArguments();
        if (arguments.size() != 1) {
            throw new SharedTypeException(String.format("Math type constructor must have only one argument: %s", newClassTree));
        }
        ExpressionTree argument = arguments.get(0);
        ValueResolveContext nextParsingContext = parsingContext.toBuilder().tree(argument).build();
        return Objects.toString(this.recursivelyResolve(nextParsingContext));
    }

    private static Element recursivelyResolveReferencedElement(ExpressionTree valueTree, ValueResolveContext parsingContext) {
        TypeElement enclosingTypeElement = parsingContext.getEnclosingTypeElement();
        Element referencedElement = null;
        if (valueTree instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)valueTree;
            String name = identifierTree.getName().toString();
            Scope scope = parsingContext.getScope();
            referencedElement = ValueResolveUtils.findElementInLocalScope(scope, name, enclosingTypeElement);
            if (referencedElement == null) {
                referencedElement = ValueResolveUtils.findEnclosedElement(parsingContext.getPackageElement(), name);
            }
            if (referencedElement == null) {
                referencedElement = ValueResolverBackendImpl.findElementInInheritedScope(name, parsingContext);
            }
        } else if (valueTree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)valueTree;
            TypeElement typeElementFromQualifiedName = parsingContext.getElements().getTypeElement(memberSelectTree.toString());
            if (typeElementFromQualifiedName != null) {
                return typeElementFromQualifiedName;
            }
            ExpressionTree expressionTree = memberSelectTree.getExpression();
            Element selecteeElement = ValueResolverBackendImpl.recursivelyResolveReferencedElement(expressionTree, parsingContext);
            if (!(selecteeElement instanceof TypeElement)) {
                throw new SharedTypeException(String.format("A selectee element must be typeElement, but found: %s in %s", selecteeElement, enclosingTypeElement));
            }
            referencedElement = ValueResolveUtils.findEnclosedElement(selecteeElement, memberSelectTree.getIdentifier().toString());
        }
        if (referencedElement == null) {
            String hint = "";
            if (valueTree instanceof MethodInvocationTree) {
                hint = " Method invocation is not support for parsing value at compile time.";
            }
            throw new SharedTypeException(String.format("Failed find referenced element from tree[Kind=%s]: '%s', when trying to parse value from field '%s' in '%s'." + hint, new Object[]{valueTree.getKind(), valueTree, parsingContext.getFieldElement(), enclosingTypeElement}));
        }
        return referencedElement;
    }

    private static @Nullable Element findElementInInheritedScope(String name, ValueResolveContext parsingContext) {
        TypeElement curEnclosingTypeElement = parsingContext.getEnclosingTypeElement();
        while (curEnclosingTypeElement != null) {
            List<? extends TypeMirror> superTypes = parsingContext.getTypes().directSupertypes(curEnclosingTypeElement.asType());
            for (TypeMirror typeMirror : superTypes) {
                Element referencedElement = ValueResolveUtils.findEnclosedElement(parsingContext.getTypes().asElement(typeMirror), name);
                if (referencedElement == null) continue;
                return referencedElement;
            }
            curEnclosingTypeElement = ValueResolveUtils.getEnclosingTypeElement(curEnclosingTypeElement);
        }
        return null;
    }

    @Generated
    public ValueResolverBackendImpl(ValueParser valueParser) {
        this.valueParser = valueParser;
    }
}

