/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.resolver;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.component.ConstantField;
import online.sharedtype.processor.domain.component.EnumValueInfo;
import online.sharedtype.processor.domain.component.FieldComponentInfo;
import online.sharedtype.processor.domain.def.ClassDef;
import online.sharedtype.processor.domain.def.ConstantNamespaceDef;
import online.sharedtype.processor.domain.def.EnumDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.ArrayTypeInfo;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.MapTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.domain.type.TypeVariableInfo;
import online.sharedtype.processor.parser.TypeDefParser;
import online.sharedtype.processor.resolver.TypeResolver;
import online.sharedtype.processor.support.exception.SharedTypeInternalError;

final class LoopTypeResolver
implements TypeResolver {
    private static final int MAX_LOOP = 2000;
    private static final int DEPENDENCY_COUNT_EXPANSION_FACTOR = 2;
    private final Context ctx;
    private final TypeDefParser typeDefParser;

    @Override
    public List<TypeDef> resolve(List<TypeDef> typeDefs) {
        int n = typeDefs.size() * 2;
        LinkedHashSet<TypeDef> resolvedDefs = new LinkedHashSet<TypeDef>(n);
        ArrayDeque<TypeDef> processingDefStack = new ArrayDeque<TypeDef>(n);
        ArrayDeque<TypeInfo> processingInfoStack = new ArrayDeque<TypeInfo>(n);
        processingDefStack.addAll(typeDefs);
        int loopCount = 0;
        while (!processingDefStack.isEmpty()) {
            if (++loopCount > 2000) {
                throw new SharedTypeInternalError("Resolving typeDefs has exceeded the maximum loop count.");
            }
            TypeDef typeDef = (TypeDef)processingDefStack.pop();
            if (resolvedDefs.contains(typeDef)) continue;
            if (typeDef.resolved()) {
                resolvedDefs.add(typeDef);
                continue;
            }
            processingDefStack.push(typeDef);
            if (typeDef instanceof ClassDef) {
                ClassDef classDef = (ClassDef)typeDef;
                for (FieldComponentInfo fieldComponentInfo : classDef.components()) {
                    if (fieldComponentInfo.resolved()) continue;
                    processingInfoStack.push(fieldComponentInfo.type());
                }
                for (TypeInfo supertype : classDef.directSupertypes()) {
                    if (supertype.resolved()) continue;
                    processingInfoStack.push(supertype);
                }
                for (TypeVariableInfo typeVariableInfo : classDef.typeVariables()) {
                    if (typeVariableInfo.resolved()) continue;
                    processingInfoStack.push(typeVariableInfo);
                }
            } else if (typeDef instanceof EnumDef) {
                EnumDef enumDef = (EnumDef)typeDef;
                for (EnumValueInfo component : enumDef.components()) {
                    if (component.resolved()) continue;
                    processingInfoStack.push(component.value().getValueType());
                }
            } else if (typeDef instanceof ConstantNamespaceDef) {
                ConstantNamespaceDef constantNamespaceDef = (ConstantNamespaceDef)typeDef;
                for (ConstantField constantField : constantNamespaceDef.components()) {
                    if (constantField.resolved()) continue;
                    processingInfoStack.push(constantField.value().getValueType());
                }
            } else {
                throw new SharedTypeInternalError(String.format("Unsupported TypeDef:'%s' of type '%s'", typeDef.qualifiedName(), typeDef.getClass()));
            }
            this.resolveTypeInfo(processingDefStack, processingInfoStack);
        }
        return new ArrayList<TypeDef>(resolvedDefs);
    }

    private void resolveTypeInfo(Deque<TypeDef> processingDefStack, Deque<TypeInfo> processingInfoStack) {
        int loopCount = 0;
        while (!processingInfoStack.isEmpty()) {
            if (++loopCount > 2000) {
                throw new SharedTypeInternalError("Resolving typeInfo has exceeded the maximum loop count.");
            }
            TypeInfo typeInfo = processingInfoStack.pop();
            if (typeInfo instanceof ConcreteTypeInfo) {
                ConcreteTypeInfo concreteTypeInfo = (ConcreteTypeInfo)typeInfo;
                if (!concreteTypeInfo.shallowResolved()) {
                    TypeElement typeElement = this.ctx.getProcessingEnv().getElementUtils().getTypeElement(concreteTypeInfo.qualifiedName());
                    List<TypeDef> parsed = this.typeDefParser.parse(typeElement);
                    if (!parsed.isEmpty()) {
                        TypeDef mainTypeDef = parsed.get(0);
                        concreteTypeInfo.markShallowResolved(mainTypeDef);
                        processingDefStack.push(mainTypeDef);
                    } else if (this.ctx.isIgnored(typeElement)) {
                        concreteTypeInfo.markShallowResolved(null);
                    }
                }
                for (TypeInfo typeArg : concreteTypeInfo.typeArgs()) {
                    if (typeArg.resolved()) continue;
                    processingInfoStack.push(typeArg);
                }
                continue;
            }
            if (typeInfo instanceof ArrayTypeInfo) {
                ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
                if (arrayTypeInfo.resolved()) continue;
                processingInfoStack.push(arrayTypeInfo.component());
                continue;
            }
            if (typeInfo instanceof MapTypeInfo) {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                if (mapTypeInfo.resolved()) continue;
                processingInfoStack.push(mapTypeInfo.keyType());
                processingInfoStack.push(mapTypeInfo.valueType());
                continue;
            }
            if (typeInfo instanceof TypeVariableInfo) {
                TypeVariableInfo typeVariableInfo = (TypeVariableInfo)typeInfo;
                throw new SharedTypeInternalError("TypeVariableInfo is not supported yet: " + typeVariableInfo);
            }
            throw new SharedTypeInternalError(String.format("Only ConcreteTypeInfo needs to be resolved, but got: %s of %s", typeInfo, typeInfo.getClass()));
        }
    }

    @Generated
    public LoopTypeResolver(Context ctx, TypeDefParser typeDefParser) {
        this.ctx = ctx;
        this.typeDefParser = typeDefParser;
    }
}

