/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.resolver;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.component.FieldComponentInfo;
import online.sharedtype.processor.domain.def.ClassDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.ArrayTypeInfo;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.MapTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.resolver.TypeResolver;

final class OptionalTypeResolver
implements TypeResolver {
    private final Context ctx;

    @Override
    public List<TypeDef> resolve(List<TypeDef> typeDefs) {
        ArrayList<TypeDef> result = new ArrayList<TypeDef>(typeDefs.size());
        for (TypeDef typeDef : typeDefs) {
            if (typeDef instanceof ClassDef) {
                ClassDef classDef = (ClassDef)typeDef;
                this.resolveOptionalTypes(classDef);
            }
            result.add(typeDef);
        }
        return result;
    }

    private void resolveOptionalTypes(ClassDef classDef) {
        for (FieldComponentInfo component : classDef.components()) {
            ConcreteTypeInfo concreteTypeInfo;
            TypeInfo fieldTypeInfo = component.type();
            if (fieldTypeInfo instanceof ConcreteTypeInfo && this.ctx.isOptionalType((concreteTypeInfo = (ConcreteTypeInfo)fieldTypeInfo).qualifiedName())) {
                component.setOptional(true);
            }
            component.setType(this.recursivelyFlattenOptionalTypes(fieldTypeInfo, classDef));
        }
    }

    private TypeInfo recursivelyFlattenOptionalTypes(TypeInfo typeInfo, ClassDef ctxTypeDef) {
        if (typeInfo instanceof ConcreteTypeInfo) {
            ConcreteTypeInfo concreteTypeInfo = (ConcreteTypeInfo)typeInfo;
            if (this.ctx.isOptionalType(concreteTypeInfo.qualifiedName())) {
                if (concreteTypeInfo.typeArgs().size() != 1) {
                    this.ctx.error(ctxTypeDef.getElement(), "Optional type %s in %s should have exactly one type argument. Check configuration if optional types are wrongly defined.", concreteTypeInfo.qualifiedName(), ctxTypeDef.qualifiedName());
                }
                return this.recursivelyFlattenOptionalTypes(concreteTypeInfo.typeArgs().get(0), ctxTypeDef);
            }
            if (!concreteTypeInfo.typeArgs().isEmpty()) {
                concreteTypeInfo.typeArgs().replaceAll(elem -> this.recursivelyFlattenOptionalTypes((TypeInfo)elem, ctxTypeDef));
            }
        } else {
            if (typeInfo instanceof ArrayTypeInfo) {
                ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
                return new ArrayTypeInfo(this.recursivelyFlattenOptionalTypes(arrayTypeInfo.component(), ctxTypeDef));
            }
            if (typeInfo instanceof MapTypeInfo) {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return mapTypeInfo.toBuilder().valueType(this.recursivelyFlattenOptionalTypes(mapTypeInfo.valueType(), ctxTypeDef)).build();
            }
        }
        return typeInfo;
    }

    @Generated
    public OptionalTypeResolver(Context ctx) {
        this.ctx = ctx;
    }
}

