/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.resolver;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import online.sharedtype.processor.domain.def.ConcreteTypeDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.resolver.TypeResolver;

final class ReferenceResolver
implements TypeResolver {
    ReferenceResolver() {
    }

    @Override
    public List<TypeDef> resolve(List<TypeDef> typeDefs) {
        for (TypeDef typeDef : typeDefs) {
            ReferenceResolver.traverse(typeDef);
        }
        return typeDefs;
    }

    private static void traverse(TypeDef typeDef) {
        HashSet<TypeDef> visited = new HashSet<TypeDef>();
        ArrayDeque<TypeDef> typeDefStack = new ArrayDeque<TypeDef>();
        typeDefStack.push(typeDef);
        boolean referencedByAnnotated = typeDef.isReferencedByAnnotated();
        while (!typeDefStack.isEmpty()) {
            TypeDef cur = (TypeDef)typeDefStack.pop();
            if (visited.contains(cur)) {
                cur.setCyclicReferenced(true);
                continue;
            }
            visited.add(cur);
            if (!(cur instanceof ConcreteTypeDef)) continue;
            ConcreteTypeDef curConcreteTypeDef = (ConcreteTypeDef)cur;
            List referencingTypeDefs = curConcreteTypeDef.typeInfoSet().stream().flatMap(ts -> ts.referencingTypes().stream()).collect(Collectors.toList());
            if (!referencingTypeDefs.isEmpty()) {
                curConcreteTypeDef.setDepended(true);
            }
            for (TypeDef referencingTypeDef : referencingTypeDefs) {
                ConcreteTypeDef dependingClassDef;
                typeDefStack.push(referencingTypeDef);
                if (!(referencingTypeDef instanceof ConcreteTypeDef) || !(dependingClassDef = (ConcreteTypeDef)referencingTypeDef).isAnnotated() && !dependingClassDef.isReferencedByAnnotated()) continue;
                cur.setReferencedByAnnotated(true);
                referencedByAnnotated = true;
            }
        }
        typeDef.setReferencedByAnnotated(referencedByAnnotated);
    }
}

