/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.support.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import lombok.Generated;
import online.sharedtype.processor.support.exception.SharedTypeException;
import online.sharedtype.processor.support.exception.SharedTypeInternalError;

public final class Utils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String substringAndUncapitalize(String str, int beginIndex) {
        try {
            return Character.toLowerCase(str.charAt(beginIndex)) + str.substring(beginIndex + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SharedTypeInternalError(String.format("Failed to substringAndUncapitalize string: '%s'", str), e);
        }
    }

    public static String[] emptyStringArray() {
        return EMPTY_STRING_ARRAY;
    }

    public static String notEmptyOrDefault(String value, String defaultValue, Supplier<String> message) {
        String res;
        String string = res = value != null && !value.isEmpty() ? value : defaultValue;
        if (res == null || res.isEmpty()) {
            throw new SharedTypeException("Either value or defaultValue must not be empty. " + message.get());
        }
        return res;
    }

    public static List<VariableElement> allInstanceFields(TypeElement typeElement) {
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>(enclosedElements.size());
        for (Element element : enclosedElements) {
            if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            fields.add((VariableElement)element);
        }
        return fields;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

