/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.tools.FileObject;
import lombok.Generated;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.def.ConstantNamespaceDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.support.exception.SharedTypeException;
import online.sharedtype.processor.writer.TypeWriter;

final class JavaSerializationFileWriter
implements TypeWriter {
    private final Context ctx;

    @Override
    public void write(List<TypeDef> typeDefs) {
        try {
            for (TypeDef typeDef : typeDefs) {
                FileObject file = this.ctx.createSourceOutput(this.getTypeName(typeDef) + ".ser");
                OutputStream outputStream = file.openOutputStream();
                try (ObjectOutputStream oos = new ObjectOutputStream(outputStream);){
                    oos.writeObject(typeDef);
                }
                finally {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new SharedTypeException("Failed to write to file,", e);
        }
    }

    private String getTypeName(TypeDef typeDef) {
        if (typeDef instanceof ConstantNamespaceDef) {
            return String.format("$%s", typeDef.qualifiedName());
        }
        return typeDef.qualifiedName();
    }

    @Generated
    public JavaSerializationFileWriter(Context ctx) {
        this.ctx = ctx;
    }
}

