/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import lombok.Generated;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.def.ConstantNamespaceDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.writer.TypeWriter;
import online.sharedtype.processor.writer.adaptor.RenderDataAdaptorFactory;
import online.sharedtype.processor.writer.converter.TemplateDataConverter;
import online.sharedtype.processor.writer.render.TemplateRenderer;

final class TemplateTypeFileWriter
implements TypeWriter {
    private final Context ctx;
    private final TemplateRenderer renderer;
    private final RenderDataAdaptorFactory renderDataAdaptorFactory;
    private final Set<TemplateDataConverter> converters;
    private final String outputFileName;

    @Override
    public void write(List<TypeDef> typeDefs) throws IOException {
        ArrayList data = new ArrayList(typeDefs.size() * this.converters.size());
        data.add(this.renderDataAdaptorFactory.header(this.ctx));
        HashMap<String, TypeDef> simpleNames = new HashMap<String, TypeDef>(typeDefs.size());
        for (TypeDef typeDef : typeDefs) {
            TypeDef duplicate;
            TypeDef typeDef2 = duplicate = typeDef instanceof ConstantNamespaceDef ? null : (TypeDef)simpleNames.get(typeDef.simpleName());
            if (duplicate != null) {
                this.ctx.warn("Duplicate names found: %s and %s, which may not be valid in output code. You may use @SharedType(name=\"...\") to rename a type.", typeDef.qualifiedName(), duplicate.qualifiedName());
            }
            simpleNames.put(typeDef.simpleName(), typeDef);
            for (TemplateDataConverter converter : this.converters) {
                if (!converter.shouldAccept(typeDef)) continue;
                data.add(converter.convert(typeDef));
            }
        }
        FileObject file = this.ctx.createSourceOutput(this.outputFileName);
        try (OutputStream outputStream = file.openOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
            this.renderer.render(writer, data);
        }
    }

    @Generated
    public TemplateTypeFileWriter(Context ctx, TemplateRenderer renderer, RenderDataAdaptorFactory renderDataAdaptorFactory, Set<TemplateDataConverter> converters, String outputFileName) {
        this.ctx = ctx;
        this.renderer = renderer;
        this.renderDataAdaptorFactory = renderDataAdaptorFactory;
        this.converters = converters;
        this.outputFileName = outputFileName;
    }
}

