/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.OutputTarget;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.writer.CompositeWriter;
import online.sharedtype.processor.writer.ConsoleWriter;
import online.sharedtype.processor.writer.JavaSerializationFileWriter;
import online.sharedtype.processor.writer.TemplateTypeFileWriter;
import online.sharedtype.processor.writer.adaptor.RenderDataAdaptorFactory;
import online.sharedtype.processor.writer.converter.TemplateDataConverter;
import online.sharedtype.processor.writer.render.TemplateRenderer;

public interface TypeWriter {
    public void write(List<TypeDef> var1) throws IOException;

    public static TypeWriter create(Context ctx) {
        HashSet<TypeWriter> writers = new HashSet<TypeWriter>(OutputTarget.values().length);
        if (ctx.getProps().getTargets().contains((Object)OutputTarget.CONSOLE)) {
            writers.add(new ConsoleWriter(ctx));
        }
        if (ctx.getProps().getTargets().contains((Object)OutputTarget.JAVA_SERIALIZED)) {
            writers.add(new JavaSerializationFileWriter(ctx));
        }
        TemplateRenderer renderer = TemplateRenderer.create();
        if (ctx.getProps().getTargets().contains((Object)OutputTarget.TYPESCRIPT)) {
            writers.add(new TemplateTypeFileWriter(ctx, renderer, RenderDataAdaptorFactory::typescript, TemplateDataConverter.typescript(ctx), ctx.getProps().getTypescript().getOutputFileName()));
        }
        if (ctx.getProps().getTargets().contains((Object)OutputTarget.GO)) {
            writers.add(new TemplateTypeFileWriter(ctx, renderer, RenderDataAdaptorFactory::go, TemplateDataConverter.go(ctx), ctx.getProps().getGo().getOutputFileName()));
        }
        if (ctx.getProps().getTargets().contains((Object)OutputTarget.RUST)) {
            writers.add(new TemplateTypeFileWriter(ctx, renderer, RenderDataAdaptorFactory::rust, TemplateDataConverter.rust(ctx), ctx.getProps().getRust().getOutputFileName()));
        }
        return new CompositeWriter(writers);
    }
}

