/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.adaptor;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import lombok.Generated;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.RenderFlags;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.support.exception.SharedTypeException;
import online.sharedtype.processor.writer.adaptor.RenderDataAdaptor;

abstract class AbstractDataAdaptor
implements RenderDataAdaptor {
    final Context ctx;

    final RenderFlags renderFlags() {
        return this.ctx.getRenderFlags();
    }

    abstract String customCodeSnippet();

    static String readCustomCodeSnippet(@Nullable Path customCodePath) {
        if (customCodePath == null) {
            return "";
        }
        if (Files.notExists(customCodePath, new LinkOption[0])) {
            throw new SharedTypeException(String.format("Custom code snippet not found at path '%s'", customCodePath));
        }
        try {
            return new String(Files.readAllBytes(customCodePath));
        }
        catch (IOException e) {
            throw new SharedTypeException(String.format("Failed to read custom code snippet from path '%s'", customCodePath), e);
        }
    }

    @Generated
    public AbstractDataAdaptor(Context ctx) {
        this.ctx = ctx;
    }
}

