/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.ArrayList;
import java.util.List;
import online.sharedtype.SharedType;
import online.sharedtype.processor.domain.component.ComponentInfo;
import online.sharedtype.processor.domain.component.TagLiteralContainer;

abstract class AbstractFieldExpr {
    final String name;
    final List<String> tagLiteralsAbove;
    final String tagLiteralsInlineAfter;

    AbstractFieldExpr(ComponentInfo componentInfo, SharedType.TargetType targetType) {
        this.name = componentInfo.name();
        List<TagLiteralContainer> tagLiterals = componentInfo.getTagLiterals(targetType);
        this.tagLiteralsAbove = new ArrayList<String>(tagLiterals.size());
        StringBuilder inlineTagsBuilder = new StringBuilder();
        for (TagLiteralContainer tagLiteral : tagLiterals) {
            if (tagLiteral.getPosition() == SharedType.TagPosition.NEWLINE_ABOVE) {
                this.tagLiteralsAbove.addAll(tagLiteral.getContents());
                continue;
            }
            if (tagLiteral.getPosition() == SharedType.TagPosition.INLINE_AFTER) {
                inlineTagsBuilder.append(String.join((CharSequence)" ", tagLiteral.getContents()));
                continue;
            }
            throw new IllegalArgumentException("Unknown tag literal position: " + tagLiteral.getPosition());
        }
        this.tagLiteralsInlineAfter = inlineTagsBuilder.toString();
    }
}

