/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.stream.Collectors;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.component.ComponentInfo;
import online.sharedtype.processor.domain.component.ConstantField;
import online.sharedtype.processor.domain.def.ConstantNamespaceDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.support.utils.Tuple;
import online.sharedtype.processor.writer.converter.AbstractConstantConverter;
import online.sharedtype.processor.writer.converter.AbstractFieldExpr;
import online.sharedtype.processor.writer.converter.AbstractTypeExpr;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;
import online.sharedtype.processor.writer.render.Template;

final class DefaultConstantConverter
extends AbstractConstantConverter {
    private final Context ctx;
    private final TypeExpressionConverter typeExpressionConverter;
    private final SharedType.TargetType targetType;

    @Override
    public Tuple<Template, AbstractTypeExpr> convert(TypeDef typeDef) {
        ConstantNamespaceDef constantNamespaceDef = (ConstantNamespaceDef)typeDef;
        AbstractConstantConverter.ConstantNamespaceExpr value = new AbstractConstantConverter.ConstantNamespaceExpr(constantNamespaceDef.simpleName(), constantNamespaceDef.components().stream().map(field -> this.toConstantExpr((ConstantField)field, typeDef)).collect(Collectors.toList()));
        Config config = this.ctx.getTypeStore().getConfig(typeDef);
        return Tuple.of(Template.forConstant(this.targetType, config.isConstantNamespaced()), value);
    }

    private ConstantExpr toConstantExpr(ConstantField constantField, TypeDef contextTypeDef) {
        return new ConstantExpr(constantField, this.typeExpressionConverter.toTypeExpr(constantField.value().getValueType(), contextTypeDef), constantField.value().literalValue());
    }

    @Generated
    public DefaultConstantConverter(Context ctx, TypeExpressionConverter typeExpressionConverter, SharedType.TargetType targetType) {
        this.ctx = ctx;
        this.typeExpressionConverter = typeExpressionConverter;
        this.targetType = targetType;
    }

    final class ConstantExpr
    extends AbstractFieldExpr {
        final String type;
        final String value;

        ConstantExpr(ComponentInfo componentInfo, String type, String value) {
            super(componentInfo, DefaultConstantConverter.this.targetType);
            this.type = type;
            this.value = value;
        }
    }
}

