/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.Props;
import online.sharedtype.processor.domain.component.ComponentInfo;
import online.sharedtype.processor.domain.component.EnumValueInfo;
import online.sharedtype.processor.domain.def.EnumDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.support.utils.Tuple;
import online.sharedtype.processor.writer.converter.AbstractEnumConverter;
import online.sharedtype.processor.writer.converter.AbstractFieldExpr;
import online.sharedtype.processor.writer.converter.AbstractTypeExpr;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;
import online.sharedtype.processor.writer.render.Template;

final class GoEnumConverter
extends AbstractEnumConverter {
    private final Context ctx;
    private final TypeExpressionConverter typeExpressionConverter;

    @Override
    public Tuple<Template, AbstractTypeExpr> convert(TypeDef typeDef) {
        EnumDef enumDef = (EnumDef)typeDef;
        String valueType = this.getValueTypeExpr(enumDef);
        EnumExpr value = new EnumExpr(enumDef.simpleName(), enumDef.components().stream().map(comp -> GoEnumConverter.buildEnumExpr(comp, enumDef.simpleName())).collect(Collectors.toList()), valueType);
        Config config = this.ctx.getTypeStore().getConfig(typeDef);
        return Tuple.of(config.getGoEnumFormat() == Props.Go.EnumFormat.CONST ? Template.TEMPLATE_GO_CONST_ENUM : Template.TEMPLATE_GO_STRUCT_ENUM, value);
    }

    private static EnumerationExpr buildEnumExpr(EnumValueInfo component, String valueTypeExpr) {
        return new EnumerationExpr(component, valueTypeExpr, component.value().literalValue());
    }

    private String getValueTypeExpr(EnumDef enumDef) {
        EnumValueInfo component = enumDef.components().get(0);
        TypeInfo enumTypeInfo = enumDef.typeInfoSet().iterator().next();
        if (enumTypeInfo.equals(component.value().getValueType())) {
            return "string";
        }
        return this.typeExpressionConverter.toTypeExpr(component.value().getValueType(), enumDef);
    }

    @Generated
    public GoEnumConverter(Context ctx, TypeExpressionConverter typeExpressionConverter) {
        this.ctx = ctx;
        this.typeExpressionConverter = typeExpressionConverter;
    }

    static final class EnumExpr
    extends AbstractTypeExpr {
        final String name;
        final List<EnumerationExpr> enumerations;
        final String valueType;

        @Generated
        public EnumExpr(String name, List<EnumerationExpr> enumerations, String valueType) {
            this.name = name;
            this.enumerations = enumerations;
            this.valueType = valueType;
        }
    }

    static final class EnumerationExpr
    extends AbstractFieldExpr {
        final String enumName;
        @Nullable
        final String value;

        EnumerationExpr(ComponentInfo componentInfo, String enumName, @Nullable String value) {
            super(componentInfo, SharedType.TargetType.GO);
            this.enumName = enumName;
            this.value = value;
        }
    }
}

