/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.domain.component.ComponentInfo;
import online.sharedtype.processor.domain.component.FieldComponentInfo;
import online.sharedtype.processor.domain.def.ClassDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.support.utils.Tuple;
import online.sharedtype.processor.support.utils.Utils;
import online.sharedtype.processor.writer.converter.AbstractFieldExpr;
import online.sharedtype.processor.writer.converter.AbstractStructConverter;
import online.sharedtype.processor.writer.converter.AbstractTypeExpr;
import online.sharedtype.processor.writer.converter.ConversionUtils;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;
import online.sharedtype.processor.writer.render.Template;

final class GoStructConverter
extends AbstractStructConverter {
    private final TypeExpressionConverter typeExpressionConverter;

    @Override
    public Tuple<Template, AbstractTypeExpr> convert(TypeDef typeDef) {
        ClassDef classDef = (ClassDef)typeDef;
        StructExpr value = new StructExpr(classDef.simpleName(), classDef.typeVariables().stream().map(typeInfo -> this.typeExpressionConverter.toTypeExpr((TypeInfo)typeInfo, typeDef)).collect(Collectors.toList()), classDef.directSupertypes().stream().map(typeInfo1 -> this.typeExpressionConverter.toTypeExpr((TypeInfo)typeInfo1, typeDef)).collect(Collectors.toList()), this.gatherProperties(classDef));
        return Tuple.of(Template.TEMPLATE_GO_STRUCT, value);
    }

    private List<PropertyExpr> gatherProperties(ClassDef classDef) {
        ArrayList<PropertyExpr> properties = new ArrayList<PropertyExpr>();
        for (FieldComponentInfo component : classDef.components()) {
            properties.add(this.toPropertyExpr(component, classDef));
        }
        return properties;
    }

    private PropertyExpr toPropertyExpr(FieldComponentInfo field, TypeDef contextTypeDef) {
        return new PropertyExpr(field, this.typeExpressionConverter.toTypeExpr(field.type(), contextTypeDef), ConversionUtils.isOptionalField(field));
    }

    @Generated
    public GoStructConverter(TypeExpressionConverter typeExpressionConverter) {
        this.typeExpressionConverter = typeExpressionConverter;
    }

    static final class StructExpr
    extends AbstractTypeExpr {
        final String name;
        final List<String> typeParameters;
        final List<String> supertypes;
        final List<PropertyExpr> properties;

        String typeParametersExpr() {
            if (this.typeParameters.isEmpty()) {
                return null;
            }
            return String.format("[%s any]", String.join((CharSequence)", ", this.typeParameters));
        }

        @Generated
        public StructExpr(String name, List<String> typeParameters, List<String> supertypes, List<PropertyExpr> properties) {
            this.name = name;
            this.typeParameters = typeParameters;
            this.supertypes = supertypes;
            this.properties = properties;
        }
    }

    static final class PropertyExpr
    extends AbstractFieldExpr {
        final String type;
        final boolean optional;

        PropertyExpr(ComponentInfo componentInfo, String type, boolean optional) {
            super(componentInfo, SharedType.TargetType.GO);
            this.type = type;
            this.optional = optional;
        }

        String capitalizedName() {
            return ConversionUtils.capitalize(this.name);
        }

        String typeExpr() {
            if (this.optional) {
                return String.format("*%s", this.type);
            }
            return this.type;
        }

        String inlineTagsExpr() {
            if (!Utils.isBlank(this.tagLiteralsInlineAfter)) {
                return this.tagLiteralsInlineAfter;
            }
            HashSet<String> jsonTags = new HashSet<String>(2);
            jsonTags.add(this.name);
            if (this.optional) {
                jsonTags.add("omitempty");
            }
            return String.format("`json:\"%s\"`", String.join((CharSequence)",", jsonTags));
        }

        @Generated
        public String toString() {
            return "GoStructConverter.PropertyExpr(type=" + this.type + ", optional=" + this.optional + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyExpr)) {
                return false;
            }
            PropertyExpr other = (PropertyExpr)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PropertyExpr;
        }

        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

