/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.component.ComponentInfo;
import online.sharedtype.processor.domain.component.EnumValueInfo;
import online.sharedtype.processor.domain.def.EnumDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.value.EnumConstantValue;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.support.utils.Tuple;
import online.sharedtype.processor.writer.converter.AbstractEnumConverter;
import online.sharedtype.processor.writer.converter.AbstractFieldExpr;
import online.sharedtype.processor.writer.converter.AbstractTypeExpr;
import online.sharedtype.processor.writer.converter.ConversionUtils;
import online.sharedtype.processor.writer.converter.RustMacroTraitsGenerator;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;
import online.sharedtype.processor.writer.render.Template;

final class RustEnumConverter
extends AbstractEnumConverter {
    private final Context ctx;
    private final TypeExpressionConverter typeExpressionConverter;
    private final RustMacroTraitsGenerator rustMacroTraitsGenerator;

    @Override
    public Tuple<Template, AbstractTypeExpr> convert(TypeDef typeDef) {
        EnumDef enumDef = (EnumDef)typeDef;
        String valueType = this.getValueTypeExpr(enumDef);
        boolean hasValue = valueType != null;
        EnumExpr value = new EnumExpr(enumDef.simpleName(), this.extractEnumValues(enumDef.components()), this.rustMacroTraitsGenerator.generate(enumDef), hasValue, valueType, hasValue && this.ctx.getProps().getRust().hasEnumValueTypeAlias() ? enumDef.valueTypeAlias() : null);
        return Tuple.of(Template.TEMPLATE_RUST_ENUM, value);
    }

    private @Nullable String getValueTypeExpr(EnumDef enumDef) {
        if (enumDef.hasComponentValueType()) {
            return this.typeExpressionConverter.toTypeExpr(enumDef.getComponentValueType(), enumDef);
        }
        return null;
    }

    private List<EnumerationExpr> extractEnumValues(List<EnumValueInfo> components) {
        ArrayList<EnumerationExpr> exprs = new ArrayList<EnumerationExpr>(components.size());
        for (EnumValueInfo component : components) {
            boolean isEnum = component.value().getValueType().getKind() == ConcreteTypeInfo.Kind.ENUM;
            exprs.add(new EnumerationExpr((ComponentInfo)component, isEnum ? RustEnumConverter.rustEnumSelectExpr(component.value()) : component.value().literalValue()));
        }
        return exprs;
    }

    private static String rustEnumSelectExpr(EnumConstantValue enumConstantValue) {
        String enumName = enumConstantValue.getValueType().simpleName();
        String variantName = Objects.toString(enumConstantValue.getValue());
        return String.format("%s::%s", enumName, variantName);
    }

    @Generated
    public RustEnumConverter(Context ctx, TypeExpressionConverter typeExpressionConverter, RustMacroTraitsGenerator rustMacroTraitsGenerator) {
        this.ctx = ctx;
        this.typeExpressionConverter = typeExpressionConverter;
        this.rustMacroTraitsGenerator = rustMacroTraitsGenerator;
    }

    static final class EnumExpr
    extends AbstractTypeExpr {
        final String name;
        final List<EnumerationExpr> enumerations;
        final Set<String> macroTraits;
        final boolean hasValue;
        @Nullable
        final String valueType;
        @Nullable
        final String valueTypeAlias;

        String macroTraitsExpr() {
            return ConversionUtils.buildRustMacroTraitsExpr(this.macroTraits);
        }

        @Generated
        public EnumExpr(String name, List<EnumerationExpr> enumerations, Set<String> macroTraits, boolean hasValue, String valueType, String valueTypeAlias) {
            this.name = name;
            this.enumerations = enumerations;
            this.macroTraits = macroTraits;
            this.hasValue = hasValue;
            this.valueType = valueType;
            this.valueTypeAlias = valueTypeAlias;
        }
    }

    static final class EnumerationExpr
    extends AbstractFieldExpr {
        @Nullable
        final String value;

        EnumerationExpr(ComponentInfo componentInfo, @Nullable String value) {
            super(componentInfo, SharedType.TargetType.RUST);
            this.value = value;
        }
    }
}

