/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.writer.converter.RustMacroTraitsGenerator;

final class RustMacroTraitsGeneratorImpl
implements RustMacroTraitsGenerator {
    final Context ctx;
    private final Set<String> defaultTraits;

    RustMacroTraitsGeneratorImpl(Context ctx) {
        this.ctx = ctx;
        this.defaultTraits = ctx.getProps().getRust().getDefaultTypeMacros();
    }

    @Override
    public Set<String> generate(TypeDef typeDef) {
        Config config = this.ctx.getTypeStore().getConfig(typeDef);
        String[] typeMacroTraits = config.getAnno().rustMacroTraits();
        LinkedHashSet<String> traits = new LinkedHashSet<String>(typeMacroTraits.length + this.defaultTraits.size());
        traits.addAll(this.defaultTraits);
        Collections.addAll(traits, typeMacroTraits);
        return traits;
    }
}

