/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.component.ComponentInfo;
import online.sharedtype.processor.domain.component.FieldComponentInfo;
import online.sharedtype.processor.domain.def.ClassDef;
import online.sharedtype.processor.domain.def.EnumDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.support.utils.Tuple;
import online.sharedtype.processor.writer.converter.AbstractFieldExpr;
import online.sharedtype.processor.writer.converter.AbstractStructConverter;
import online.sharedtype.processor.writer.converter.AbstractTypeExpr;
import online.sharedtype.processor.writer.converter.ConversionUtils;
import online.sharedtype.processor.writer.converter.RustMacroTraitsGenerator;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;
import online.sharedtype.processor.writer.render.Template;

final class RustStructConverter
extends AbstractStructConverter {
    private final Context ctx;
    private final TypeExpressionConverter typeExpressionConverter;
    private final RustMacroTraitsGenerator rustMacroTraitsGenerator;

    @Override
    public boolean shouldAccept(TypeDef typeDef) {
        if (!super.shouldAccept(typeDef)) {
            return false;
        }
        ClassDef classDef = (ClassDef)typeDef;
        if (classDef.isAnnotated()) {
            return !classDef.components().isEmpty();
        }
        return classDef.isReferencedByAnnotated();
    }

    @Override
    public Tuple<Template, AbstractTypeExpr> convert(TypeDef typeDef) {
        ClassDef classDef = (ClassDef)typeDef;
        StructExpr value = new StructExpr(classDef.simpleName(), classDef.typeVariables().stream().map(typeInfo -> this.typeExpressionConverter.toTypeExpr((TypeInfo)typeInfo, typeDef)).collect(Collectors.toList()), this.gatherProperties(classDef), this.rustMacroTraitsGenerator.generate(classDef));
        return Tuple.of(Template.TEMPLATE_RUST_STRUCT, value);
    }

    private List<PropertyExpr> gatherProperties(ClassDef classDef) {
        ArrayList<PropertyExpr> properties = new ArrayList<PropertyExpr>();
        HashSet<String> propertyNames = new HashSet<String>();
        for (FieldComponentInfo component : classDef.components()) {
            properties.add(this.toPropertyExpr(component, classDef));
            propertyNames.add(component.name());
        }
        ArrayDeque<TypeInfo> superTypes = new ArrayDeque<TypeInfo>(classDef.directSupertypes());
        while (!superTypes.isEmpty()) {
            ConcreteTypeInfo superConcreteTypeInfo;
            ClassDef superTypeDef;
            TypeInfo supertype = (TypeInfo)superTypes.poll();
            if (!(supertype instanceof ConcreteTypeInfo) || (superTypeDef = (ClassDef)(superConcreteTypeInfo = (ConcreteTypeInfo)supertype).typeDef()) == null) continue;
            superTypeDef = superTypeDef.reify(superConcreteTypeInfo.typeArgs());
            for (FieldComponentInfo component : superTypeDef.components()) {
                if (propertyNames.contains(component.name())) continue;
                properties.add(this.toPropertyExpr(component, superTypeDef));
                propertyNames.add(component.name());
            }
            superTypes.addAll(superTypeDef.directSupertypes());
        }
        return properties;
    }

    private PropertyExpr toPropertyExpr(FieldComponentInfo field, TypeDef contextTypeDef) {
        return new PropertyExpr(field, this.ctx.getProps().getRust().isConvertToSnakeCase() ? ConversionUtils.toSnakeCase(field.name()) : field.name(), this.typeExpressionConverter.toTypeExpr(this.getFieldValueType(field), contextTypeDef), ConversionUtils.isOptionalField(field));
    }

    private TypeInfo getFieldValueType(FieldComponentInfo field) {
        ConcreteTypeInfo type;
        if (field.type() instanceof ConcreteTypeInfo && (type = (ConcreteTypeInfo)field.type()).getKind() == ConcreteTypeInfo.Kind.ENUM && type.typeDef() instanceof EnumDef) {
            return ((EnumDef)type.typeDef()).getComponentValueType();
        }
        return field.type();
    }

    @Generated
    public RustStructConverter(Context ctx, TypeExpressionConverter typeExpressionConverter, RustMacroTraitsGenerator rustMacroTraitsGenerator) {
        this.ctx = ctx;
        this.typeExpressionConverter = typeExpressionConverter;
        this.rustMacroTraitsGenerator = rustMacroTraitsGenerator;
    }

    static final class StructExpr
    extends AbstractTypeExpr {
        final String name;
        final List<String> typeParameters;
        final List<PropertyExpr> properties;
        final Set<String> macroTraits;

        String typeParametersExpr() {
            if (this.typeParameters.isEmpty()) {
                return null;
            }
            return String.format("<%s>", String.join((CharSequence)", ", this.typeParameters));
        }

        String macroTraitsExpr() {
            return ConversionUtils.buildRustMacroTraitsExpr(this.macroTraits);
        }

        @Generated
        public StructExpr(String name, List<String> typeParameters, List<PropertyExpr> properties, Set<String> macroTraits) {
            this.name = name;
            this.typeParameters = typeParameters;
            this.properties = properties;
            this.macroTraits = macroTraits;
        }
    }

    static final class PropertyExpr
    extends AbstractFieldExpr {
        final String name;
        final String type;
        final boolean optional;

        PropertyExpr(ComponentInfo componentInfo, String name, String type, boolean optional) {
            super(componentInfo, SharedType.TargetType.RUST);
            this.name = name;
            this.type = type;
            this.optional = optional;
        }

        String typeExpr() {
            return this.optional ? String.format("Option<%s>", this.type) : this.type;
        }

        @Generated
        public String toString() {
            return "RustStructConverter.PropertyExpr(name=" + this.name + ", type=" + this.type + ", optional=" + this.optional + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyExpr)) {
                return false;
            }
            PropertyExpr other = (PropertyExpr)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PropertyExpr;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }
}

