/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.HashSet;
import java.util.Set;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.support.utils.Tuple;
import online.sharedtype.processor.writer.converter.AbstractTypeExpr;
import online.sharedtype.processor.writer.converter.DefaultConstantConverter;
import online.sharedtype.processor.writer.converter.GoEnumConverter;
import online.sharedtype.processor.writer.converter.GoStructConverter;
import online.sharedtype.processor.writer.converter.RustConstantConverter;
import online.sharedtype.processor.writer.converter.RustEnumConverter;
import online.sharedtype.processor.writer.converter.RustMacroTraitsGeneratorImpl;
import online.sharedtype.processor.writer.converter.RustStructConverter;
import online.sharedtype.processor.writer.converter.TypescriptEnumConverter;
import online.sharedtype.processor.writer.converter.TypescriptInterfaceConverter;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;
import online.sharedtype.processor.writer.render.Template;

public interface TemplateDataConverter {
    public boolean shouldAccept(TypeDef var1);

    public Tuple<Template, AbstractTypeExpr> convert(TypeDef var1);

    public static Set<TemplateDataConverter> typescript(Context ctx) {
        HashSet<TemplateDataConverter> converters = new HashSet<TemplateDataConverter>(3);
        converters.add(new TypescriptInterfaceConverter(ctx, TypeExpressionConverter.typescript(ctx)));
        converters.add(new TypescriptEnumConverter(ctx));
        converters.add(new DefaultConstantConverter(ctx, TypeExpressionConverter.nullOp(), SharedType.TargetType.TYPESCRIPT));
        return converters;
    }

    public static Set<TemplateDataConverter> go(Context ctx) {
        HashSet<TemplateDataConverter> converters = new HashSet<TemplateDataConverter>(3);
        TypeExpressionConverter typeExpressionConverter = TypeExpressionConverter.go(ctx);
        converters.add(new GoStructConverter(typeExpressionConverter));
        converters.add(new GoEnumConverter(ctx, typeExpressionConverter));
        converters.add(new DefaultConstantConverter(ctx, typeExpressionConverter, SharedType.TargetType.GO));
        return converters;
    }

    public static Set<TemplateDataConverter> rust(Context ctx) {
        RustMacroTraitsGeneratorImpl rustMacroTraitsGenerator = new RustMacroTraitsGeneratorImpl(ctx);
        TypeExpressionConverter rustTypeExpressionConverter = TypeExpressionConverter.rust(ctx);
        TypeExpressionConverter rustLiteralTypeExpressionConverter = TypeExpressionConverter.rustLiteral(ctx);
        HashSet<TemplateDataConverter> converters = new HashSet<TemplateDataConverter>(3);
        converters.add(new RustStructConverter(ctx, rustTypeExpressionConverter, rustMacroTraitsGenerator));
        converters.add(new RustEnumConverter(ctx, rustLiteralTypeExpressionConverter, rustMacroTraitsGenerator));
        converters.add(new RustConstantConverter(ctx, rustLiteralTypeExpressionConverter));
        return converters;
    }
}

