/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.Props;
import online.sharedtype.processor.domain.component.ComponentInfo;
import online.sharedtype.processor.domain.component.EnumValueInfo;
import online.sharedtype.processor.domain.def.EnumDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.support.utils.Tuple;
import online.sharedtype.processor.writer.converter.AbstractEnumConverter;
import online.sharedtype.processor.writer.converter.AbstractFieldExpr;
import online.sharedtype.processor.writer.converter.AbstractTypeExpr;
import online.sharedtype.processor.writer.render.Template;

final class TypescriptEnumConverter
extends AbstractEnumConverter {
    private final Context ctx;

    @Override
    public Tuple<Template, AbstractTypeExpr> convert(TypeDef typeDef) {
        EnumDef enumDef = (EnumDef)typeDef;
        Config config = this.ctx.getTypeStore().getConfig(typeDef);
        if (config.getTypescriptEnumFormat() == Props.Typescript.EnumFormat.UNION) {
            ArrayList<String> values = new ArrayList<String>(enumDef.components().size());
            for (EnumValueInfo component2 : enumDef.components()) {
                values.add(component2.value().literalValue());
            }
            return Tuple.of(Template.TEMPLATE_TYPESCRIPT_UNION_TYPE_ENUM, new EnumUnionExpr(enumDef.simpleName(), values));
        }
        EnumExpr value = new EnumExpr(enumDef.simpleName(), config.getTypescriptEnumFormat() == Props.Typescript.EnumFormat.CONST_ENUM, enumDef.components().stream().map(component -> new EnumValueExpr((ComponentInfo)component, component.value().literalValue())).collect(Collectors.toList()));
        return Tuple.of(Template.TEMPLATE_TYPESCRIPT_ENUM, value);
    }

    @Generated
    public TypescriptEnumConverter(Context ctx) {
        this.ctx = ctx;
    }

    static final class EnumUnionExpr
    extends AbstractTypeExpr {
        final String name;
        final List<String> values;

        String valuesExpr() {
            return String.join((CharSequence)" | ", this.values);
        }

        @Generated
        public EnumUnionExpr(String name, List<String> values) {
            this.name = name;
            this.values = values;
        }
    }

    static final class EnumExpr
    extends AbstractTypeExpr {
        final String name;
        final boolean isConst;
        final List<EnumValueExpr> values;

        @Generated
        public EnumExpr(String name, boolean isConst, List<EnumValueExpr> values) {
            this.name = name;
            this.isConst = isConst;
            this.values = values;
        }
    }

    static final class EnumValueExpr
    extends AbstractFieldExpr {
        final String value;

        EnumValueExpr(ComponentInfo componentInfo, String value) {
            super(componentInfo, SharedType.TargetType.TYPESCRIPT);
            this.value = value;
        }
    }
}

