/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.Props;
import online.sharedtype.processor.domain.component.ComponentInfo;
import online.sharedtype.processor.domain.component.FieldComponentInfo;
import online.sharedtype.processor.domain.def.ClassDef;
import online.sharedtype.processor.domain.def.TypeDef;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.support.exception.SharedTypeInternalError;
import online.sharedtype.processor.support.utils.Tuple;
import online.sharedtype.processor.writer.converter.AbstractFieldExpr;
import online.sharedtype.processor.writer.converter.AbstractStructConverter;
import online.sharedtype.processor.writer.converter.AbstractTypeExpr;
import online.sharedtype.processor.writer.converter.ConversionUtils;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;
import online.sharedtype.processor.writer.render.Template;

final class TypescriptInterfaceConverter
extends AbstractStructConverter {
    private final Context ctx;
    private final TypeExpressionConverter typeExpressionConverter;
    private final char interfacePropertyDelimiter;

    TypescriptInterfaceConverter(Context ctx, TypeExpressionConverter typeExpressionConverter) {
        this.ctx = ctx;
        this.interfacePropertyDelimiter = ctx.getProps().getTypescript().getInterfacePropertyDelimiter();
        this.typeExpressionConverter = typeExpressionConverter;
    }

    @Override
    public Tuple<Template, AbstractTypeExpr> convert(TypeDef typeDef) {
        ClassDef classDef = (ClassDef)typeDef;
        Config config = this.ctx.getTypeStore().getConfig(typeDef);
        InterfaceExpr value = new InterfaceExpr(classDef.simpleName(), classDef.typeVariables().stream().map(typeInfo -> this.typeExpressionConverter.toTypeExpr((TypeInfo)typeInfo, typeDef)).collect(Collectors.toList()), classDef.directSupertypes().stream().map(typeInfo1 -> this.typeExpressionConverter.toTypeExpr((TypeInfo)typeInfo1, typeDef)).collect(Collectors.toList()), classDef.components().stream().map(field -> this.toPropertyExpr((FieldComponentInfo)field, typeDef, config)).collect(Collectors.toList()));
        return Tuple.of(Template.TEMPLATE_TYPESCRIPT_INTERFACE, value);
    }

    private PropertyExpr toPropertyExpr(FieldComponentInfo field, TypeDef contextTypeDef, Config config) {
        boolean isFieldOptional = ConversionUtils.isOptionalField(field);
        return new PropertyExpr(field, this.typeExpressionConverter.toTypeExpr(field.type(), contextTypeDef), this.interfacePropertyDelimiter, isFieldOptional && config.getTypescriptOptionalFieldFormats().contains((Object)Props.Typescript.OptionalFieldFormat.QUESTION_MARK), isFieldOptional && config.getTypescriptOptionalFieldFormats().contains((Object)Props.Typescript.OptionalFieldFormat.NULL), isFieldOptional && config.getTypescriptOptionalFieldFormats().contains((Object)Props.Typescript.OptionalFieldFormat.UNDEFINED), TypescriptInterfaceConverter.isFieldReadonly(field, config));
    }

    private static boolean isFieldReadonly(FieldComponentInfo field, Config config) {
        if (config.getTypescriptFieldReadonly() == Props.Typescript.FieldReadonlyType.NONE) {
            return false;
        }
        if (config.getTypescriptFieldReadonly() == Props.Typescript.FieldReadonlyType.ALL) {
            return true;
        }
        if (config.getTypescriptFieldReadonly() == Props.Typescript.FieldReadonlyType.ACYCLIC) {
            return !ConversionUtils.isOfCyclicReferencedType(field);
        }
        throw new SharedTypeInternalError("Unknown typescriptFieldReadonlyType: " + (Object)((Object)config.getTypescriptFieldReadonly()));
    }

    static final class InterfaceExpr
    extends AbstractTypeExpr {
        final String name;
        final List<String> typeParameters;
        final List<String> supertypes;
        final List<PropertyExpr> properties;

        String typeParametersExpr() {
            if (this.typeParameters.isEmpty()) {
                return null;
            }
            return String.format("<%s>", String.join((CharSequence)", ", this.typeParameters));
        }

        String supertypesExpr() {
            if (this.supertypes.isEmpty()) {
                return null;
            }
            return String.format("extends %s ", String.join((CharSequence)", ", this.supertypes));
        }

        @Generated
        public InterfaceExpr(String name, List<String> typeParameters, List<String> supertypes, List<PropertyExpr> properties) {
            this.name = name;
            this.typeParameters = typeParameters;
            this.supertypes = supertypes;
            this.properties = properties;
        }
    }

    static final class PropertyExpr
    extends AbstractFieldExpr {
        final String type;
        final char propDelimiter;
        final boolean optional;
        final boolean unionNull;
        final boolean unionUndefined;
        final boolean readonly;

        PropertyExpr(ComponentInfo componentInfo, String type, char propDelimiter, boolean optional, boolean unionNull, boolean unionUndefined, boolean readonly) {
            super(componentInfo, SharedType.TargetType.TYPESCRIPT);
            this.type = type;
            this.propDelimiter = propDelimiter;
            this.optional = optional;
            this.unionNull = unionNull;
            this.unionUndefined = unionUndefined;
            this.readonly = readonly;
        }
    }
}

