/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter.type;

import java.util.HashMap;
import java.util.Map;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.Constants;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.DateTimeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.writer.converter.type.AbstractTypeExpressionConverter;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;

final class GoTypeExpressionConverter
extends AbstractTypeExpressionConverter {
    private static final String ARRAY_LITERAL = "[]";
    private static final TypeExpressionConverter.ArraySpec ARRAY_SPEC = new TypeExpressionConverter.ArraySpec("[]", "");
    private static final TypeExpressionConverter.MapSpec DEFAULT_MAP_SPEC = new TypeExpressionConverter.MapSpec("map[", "]", "");
    private static final TypeExpressionConverter.TypeArgsSpec TYPE_ARGS_SPEC = new TypeExpressionConverter.TypeArgsSpec("[", ", ", "]");
    private static final TypeExpressionConverter.TypeArgsSpec ARRAY_TYPE_ARGS_SPEC = new TypeExpressionConverter.TypeArgsSpec("", "", "");
    final Map<TypeInfo, String> typeNameMappings = new HashMap<TypeInfo, String>(32);

    public GoTypeExpressionConverter(Context ctx) {
        super(ctx);
        this.typeNameMappings.put(Constants.BOOLEAN_TYPE_INFO, "bool");
        this.typeNameMappings.put(Constants.BYTE_TYPE_INFO, "byte");
        this.typeNameMappings.put(Constants.CHAR_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.DOUBLE_TYPE_INFO, "float64");
        this.typeNameMappings.put(Constants.FLOAT_TYPE_INFO, "float32");
        this.typeNameMappings.put(Constants.INT_TYPE_INFO, "int32");
        this.typeNameMappings.put(Constants.LONG_TYPE_INFO, "int64");
        this.typeNameMappings.put(Constants.SHORT_TYPE_INFO, "int16");
        this.typeNameMappings.put(Constants.BOXED_BOOLEAN_TYPE_INFO, "bool");
        this.typeNameMappings.put(Constants.BOXED_BYTE_TYPE_INFO, "byte");
        this.typeNameMappings.put(Constants.BOXED_CHAR_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.BOXED_DOUBLE_TYPE_INFO, "float64");
        this.typeNameMappings.put(Constants.BOXED_FLOAT_TYPE_INFO, "float32");
        this.typeNameMappings.put(Constants.BOXED_INT_TYPE_INFO, "int32");
        this.typeNameMappings.put(Constants.BOXED_LONG_TYPE_INFO, "int64");
        this.typeNameMappings.put(Constants.BOXED_SHORT_TYPE_INFO, "int16");
        this.typeNameMappings.put(Constants.BIG_DECIMAL_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.BIG_INTEGER_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.STRING_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.OBJECT_TYPE_INFO, ctx.getProps().getGo().getJavaObjectMapType());
    }

    @Override
    TypeExpressionConverter.ArraySpec arraySpec() {
        return ARRAY_SPEC;
    }

    @Override
    TypeExpressionConverter.MapSpec mapSpec(ConcreteTypeInfo typeInfo) {
        return DEFAULT_MAP_SPEC;
    }

    @Override
    TypeExpressionConverter.TypeArgsSpec typeArgsSpec(ConcreteTypeInfo typeInfo) {
        if (ARRAY_LITERAL.equals(typeInfo.mappedName(SharedType.TargetType.GO))) {
            return ARRAY_TYPE_ARGS_SPEC;
        }
        return TYPE_ARGS_SPEC;
    }

    @Override
    String dateTimeTypeExpr(DateTimeInfo dateTimeInfo, Config config) {
        return dateTimeInfo.mappedNameOrDefault(SharedType.TargetType.GO, config.getGoTargetDatetimeTypeLiteral());
    }

    @Override
    String toTypeExpression(ConcreteTypeInfo typeInfo, String defaultExpr) {
        String expr = typeInfo.mappedName(SharedType.TargetType.GO);
        if (expr == null) {
            expr = this.typeNameMappings.getOrDefault(typeInfo, defaultExpr);
        }
        return expr;
    }
}

