/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter.type;

import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.context.RenderFlags;
import online.sharedtype.processor.domain.Constants;
import online.sharedtype.processor.domain.def.EnumDef;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.DateTimeInfo;
import online.sharedtype.processor.domain.type.MapTypeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.writer.converter.type.AbstractTypeExpressionConverter;
import online.sharedtype.processor.writer.converter.type.RustTypeNameMappings;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;

final class RustTypeExpressionConverter
extends AbstractTypeExpressionConverter {
    private static final TypeExpressionConverter.ArraySpec ARRAY_SPEC = new TypeExpressionConverter.ArraySpec("Vec<", ">");
    private static final TypeExpressionConverter.MapSpec DEFAULT_MAP_SPEC = new TypeExpressionConverter.MapSpec("HashMap<", ", ", ">");
    private final RenderFlags renderFlags;

    RustTypeExpressionConverter(Context ctx) {
        super(ctx);
        this.renderFlags = ctx.getRenderFlags();
    }

    @Override
    void beforeVisitTypeInfo(TypeInfo typeInfo) {
        if (typeInfo.equals(Constants.OBJECT_TYPE_INFO)) {
            this.renderFlags.setUseRustAny(true);
        } else if (typeInfo instanceof MapTypeInfo) {
            this.renderFlags.setUseRustMap(true);
        }
    }

    @Override
    TypeExpressionConverter.ArraySpec arraySpec() {
        return ARRAY_SPEC;
    }

    @Override
    TypeExpressionConverter.MapSpec mapSpec(ConcreteTypeInfo typeInfo) {
        return DEFAULT_MAP_SPEC;
    }

    @Override
    String dateTimeTypeExpr(DateTimeInfo dateTimeInfo, Config config) {
        return dateTimeInfo.mappedNameOrDefault(SharedType.TargetType.RUST, config.getRustTargetDatetimeTypeLiteral());
    }

    @Override
    @Nullable String toTypeExpression(ConcreteTypeInfo typeInfo, @Nullable String defaultExpr) {
        String expr = typeInfo.mappedName(SharedType.TargetType.RUST);
        if (expr == null) {
            expr = RustTypeNameMappings.getOrDefault(typeInfo, defaultExpr);
        }
        if (expr != null && typeInfo.typeDef() != null && typeInfo.typeDef().isCyclicReferenced()) {
            expr = String.format("Box<%s>", expr);
        }
        return expr;
    }

    @Override
    TypeInfo mapEnumValueType(ConcreteTypeInfo enumType, EnumDef enumDef) {
        return enumDef.getComponentValueType();
    }
}

