/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.processor.writer.converter.type;

import java.util.HashMap;
import java.util.Map;
import online.sharedtype.SharedType;
import online.sharedtype.processor.context.Config;
import online.sharedtype.processor.context.Context;
import online.sharedtype.processor.domain.Constants;
import online.sharedtype.processor.domain.type.ConcreteTypeInfo;
import online.sharedtype.processor.domain.type.DateTimeInfo;
import online.sharedtype.processor.domain.type.TypeInfo;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.writer.converter.type.AbstractTypeExpressionConverter;
import online.sharedtype.processor.writer.converter.type.TypeExpressionConverter;

final class TypescriptTypeExpressionConverter
extends AbstractTypeExpressionConverter {
    private static final TypeExpressionConverter.ArraySpec ARRAY_SPEC = new TypeExpressionConverter.ArraySpec("", "[]");
    private static final TypeExpressionConverter.MapSpec DEFAULT_MAP_SPEC = new TypeExpressionConverter.MapSpec("Record<", ", ", ">");
    private static final TypeExpressionConverter.MapSpec ENUM_KEY_MAP_SPEC = new TypeExpressionConverter.MapSpec("Partial<Record<", ", ", ">>");
    final Map<TypeInfo, String> typeNameMappings = new HashMap<TypeInfo, String>(32);

    TypescriptTypeExpressionConverter(Context ctx) {
        super(ctx);
        this.typeNameMappings.put(Constants.BOOLEAN_TYPE_INFO, "boolean");
        this.typeNameMappings.put(Constants.BYTE_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.CHAR_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.DOUBLE_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.FLOAT_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.INT_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.LONG_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.SHORT_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.BOXED_BOOLEAN_TYPE_INFO, "boolean");
        this.typeNameMappings.put(Constants.BOXED_BYTE_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.BOXED_CHAR_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.BOXED_DOUBLE_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.BOXED_FLOAT_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.BOXED_INT_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.BOXED_LONG_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.BOXED_SHORT_TYPE_INFO, "number");
        this.typeNameMappings.put(Constants.BIG_DECIMAL_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.BIG_INTEGER_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.STRING_TYPE_INFO, "string");
        this.typeNameMappings.put(Constants.VOID_TYPE_INFO, "never");
        this.typeNameMappings.put(Constants.OBJECT_TYPE_INFO, ctx.getProps().getTypescript().getJavaObjectMapType());
    }

    @Override
    TypeExpressionConverter.ArraySpec arraySpec() {
        return ARRAY_SPEC;
    }

    @Override
    TypeExpressionConverter.MapSpec mapSpec(ConcreteTypeInfo typeInfo) {
        if (typeInfo.getKind() == ConcreteTypeInfo.Kind.ENUM) {
            return ENUM_KEY_MAP_SPEC;
        }
        return DEFAULT_MAP_SPEC;
    }

    @Override
    String dateTimeTypeExpr(DateTimeInfo dateTimeInfo, Config config) {
        return dateTimeInfo.mappedNameOrDefault(SharedType.TargetType.TYPESCRIPT, config.getTypescriptTargetDatetimeTypeLiteral());
    }

    @Override
    @Nullable String toTypeExpression(ConcreteTypeInfo typeInfo, String defaultExpr) {
        String expr = typeInfo.mappedName(SharedType.TargetType.TYPESCRIPT);
        if (expr == null) {
            expr = this.typeNameMappings.getOrDefault(typeInfo, defaultExpr);
        }
        return expr;
    }
}

