/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.maven;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import online.sharedtype.exec.common.DependencyResolver;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;

final class MavenDependencyResolver
implements DependencyResolver {
    private final RepositorySystem repositorySystem;
    private final MavenSession session;
    private final MavenProject project;

    MavenDependencyResolver(RepositorySystem repositorySystem, MavenSession session, MavenProject project) {
        this.repositorySystem = repositorySystem;
        this.session = session;
        this.project = project;
    }

    public List<File> getClasspathDependencies() throws Exception {
        try {
            ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
            CollectRequest collectRequest = new CollectRequest(this.project.getDependencies().stream().map(md -> RepositoryUtils.toDependency((Dependency)md, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList()), this.project.getDependencyManagement().getDependencies().stream().map(md -> RepositoryUtils.toDependency((Dependency)md, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList()), this.project.getRemoteProjectRepositories());
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setCollectRequest(collectRequest);
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.session.getRepositorySession(), dependencyRequest);
            return dependencyResult.getArtifactResults().stream().map(resolved -> resolved.getArtifact().getFile()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve dependency, ", e);
        }
    }
}

