/*
 * Decompiled with CFR 0.152.
 */
package online.sharedtype.maven;

import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.Processor;
import javax.inject.Inject;
import online.sharedtype.exec.common.AnnotationProcessorExecutor;
import online.sharedtype.exec.common.DependencyResolver;
import online.sharedtype.exec.common.Logger;
import online.sharedtype.exec.common.SharedTypeApCompilerOptions;
import online.sharedtype.maven.MavenDependencyResolver;
import online.sharedtype.maven.MavenLoggerAdaptor;
import online.sharedtype.processor.SharedTypeAnnotationProcessor;
import online.sharedtype.processor.support.annotation.Nullable;
import online.sharedtype.processor.support.exception.SharedTypeException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="gen")
public final class SharedTypeGenMojo
extends AbstractMojo {
    private static final String PROP_PROJECT_SOURCE_ENCODING = "project.build.sourceEncoding";
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private MavenSession session;
    @Inject
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-sources")
    private String outputDirectory;
    @Nullable
    @Parameter
    private String propertyFile;
    @Nullable
    @Parameter
    private Map<String, String> properties;

    public void execute() throws MojoExecutionException {
        SharedTypeAnnotationProcessor processor = new SharedTypeAnnotationProcessor();
        processor.setUserProps(this.properties);
        AnnotationProcessorExecutor apExecutor = new AnnotationProcessorExecutor((Processor)processor, (Logger)new MavenLoggerAdaptor(this.getLog()), (DependencyResolver)new MavenDependencyResolver(this.repositorySystem, this.session, this.project));
        try {
            boolean success = apExecutor.execute(this.project.getBasedir().toPath(), Paths.get(this.outputDirectory, new String[0]), (Iterable)this.project.getCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()), this.project.getProperties().getProperty(PROP_PROJECT_SOURCE_ENCODING), (Iterable)new SharedTypeApCompilerOptions(this.propertyFile).toList());
            if (!success) {
                throw new SharedTypeException("Some error during annotation processing.");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }
}

